/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.bulkbuilder.outputs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.bulkbuilder.BulkbuilderException;
import org.eclipse.smila.bulkbuilder.outputs.BulkOutput;
import org.eclipse.smila.bulkbuilder.outputs.BulkType;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.output.AppendableOutput;

public class AppendableBulkOutput
extends BulkOutput {
    private final Log _log = LogFactory.getLog(this.getClass());

    public AppendableBulkOutput(String jobName, String bulkId, BulkType bulkType) {
        super(jobName, bulkId, bulkType);
    }

    @Override
    public void addRecord(Record record) throws BulkbuilderException {
        try {
            ((AppendableOutput)this.getOutput()).appendRecord(record);
        }
        catch (IOException ex) {
            throw new BulkbuilderException(String.valueOf(ex.getClass().getSimpleName()) + " writing record to bulk " + this.getCurrentBulkId(), ex);
        }
        catch (ObjectStoreException ex) {
            throw new BulkbuilderException(String.valueOf(((Object)((Object)ex)).getClass().getSimpleName()) + " writing record to bulk " + this.getCurrentBulkId(), ex);
        }
    }

    public void addMicroBulk(byte[] microBulk, Integer numberOfRecords) throws BulkbuilderException {
        try {
            ((AppendableOutput)this.getOutput()).append(microBulk, numberOfRecords);
        }
        catch (ObjectStoreException ex) {
            throw new BulkbuilderException(String.valueOf(((Object)((Object)ex)).getClass().getSimpleName()) + " writing record to bulk " + this.getCurrentBulkId(), ex);
        }
    }

    @Override
    public void commit() {
        try {
            super.commit();
        }
        catch (BulkbuilderException ex) {
            this._log.info((Object)"Appendable bulk could not be finished, but this is not critical.", (Throwable)((Object)ex));
        }
    }

    @Override
    public long getBytesWritten() {
        return ((AppendableOutput)this.getOutput()).getBytesWritten();
    }

    @Override
    public boolean isTimedOut() {
        return this.getCommitTimeout() >= 0L && System.currentTimeMillis() - this.getBulkStartTime() >= this.getCommitTimeout();
    }
}

