/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.workermanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.workermanager.internal.WorkerRunner;

public class WorkerPool {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final ExecutorService _executor = Executors.newCachedThreadPool();
    private final CompletionService<WorkerRunner> _completionService = new ExecutorCompletionService<WorkerRunner>(this._executor);

    public Collection<WorkerRunner> getCompleted() {
        ArrayList<WorkerRunner> completed = new ArrayList<WorkerRunner>();
        Future<WorkerRunner> f = null;
        do {
            if ((f = this._completionService.poll()) == null) continue;
            try {
                completed.add(f.get(0L, TimeUnit.MILLISECONDS));
            }
            catch (ExecutionException e) {
                this._log.error((Object)"TaskWorker execution threw an exception", (Throwable)e);
            }
            catch (InterruptedException e) {
                this._log.warn((Object)"InterruptedException getting TaskWorker result", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                this._log.warn((Object)"TimeoutException getting TaskWorker result", (Throwable)e);
            }
        } while (f != null);
        return completed;
    }

    public void submit(WorkerRunner taskWorker) {
        this._completionService.submit(taskWorker);
    }

    public void close() {
        if (this._executor != null) {
            this._executor.shutdown();
        }
    }

    ExecutorService getThreadPool() {
        return this._executor;
    }
}

