/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.objectstore.filesystem;

import java.io.File;
import java.util.Date;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.objectstore.StoreObject;

public class SimpleObjectInfo
implements StoreObject {
    private final String _id;
    private final long _size;
    private final Date _timestamp;

    public SimpleObjectInfo(File file, String id) {
        this._id = id;
        this._size = file.length();
        this._timestamp = new Date(file.lastModified());
    }

    public String getId() {
        return this._id;
    }

    public long getSize() {
        return this._size;
    }

    public Date getTimestamp() {
        return new Date(this._timestamp.getTime());
    }

    public AnyMap toAny() {
        AnyMap anyMap = DataFactory.DEFAULT.createAnyMap();
        anyMap.put("id", this._id);
        anyMap.put("size", (Number)this._size);
        anyMap.put("timestamp", (Any)DataFactory.DEFAULT.createDateTimeValue(this._timestamp));
        return anyMap;
    }
}

