/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.v1.BpelCompiler11;
import org.apache.ode.bpel.compiler.v1.BpelCompiler20;
import org.apache.ode.bpel.compiler.v2.BpelCompiler20Draft;
import org.apache.ode.utils.msg.MessageBundle;

public class BpelCompilerFactory {
    private static final CommonCompilationMessages __cmsgs = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    public static int forceVersion = -1;

    public static BpelCompiler latestCompiler(BpelCompiler.Version version) throws Exception {
        if (forceVersion > 0) {
            return BpelCompilerFactory.versionCompiler(version, forceVersion);
        }
        return BpelCompilerFactory.versionCompiler(version, 2);
    }

    public static BpelCompiler versionCompiler(BpelCompiler.Version version, int n) throws Exception {
        BpelCompiler bpelCompiler = null;
        block0 : switch (n) {
            case 1: {
                switch (version) {
                    case BPEL20: {
                        bpelCompiler = new BpelCompiler20();
                        break block0;
                    }
                    case BPEL20_DRAFT: {
                        bpelCompiler = new org.apache.ode.bpel.compiler.v1.BpelCompiler20Draft();
                        break block0;
                    }
                    case BPEL11: {
                        bpelCompiler = new BpelCompiler11();
                        break block0;
                    }
                }
                CompilationMessage compilationMessage = __cmsgs.errUnrecognizedBpelVersion();
                throw new CompilationException(compilationMessage);
            }
            case 2: {
                switch (version) {
                    case BPEL20: {
                        bpelCompiler = new org.apache.ode.bpel.compiler.v2.BpelCompiler20();
                        break block0;
                    }
                    case BPEL20_DRAFT: {
                        bpelCompiler = new BpelCompiler20Draft();
                        break block0;
                    }
                    case BPEL11: {
                        bpelCompiler = new org.apache.ode.bpel.compiler.v2.BpelCompiler11();
                        break block0;
                    }
                }
                CompilationMessage compilationMessage = __cmsgs.errUnrecognizedBpelVersion();
                throw new CompilationException(compilationMessage);
            }
            default: {
                throw new RuntimeException("Non existant version: " + n);
            }
        }
        return bpelCompiler;
    }
}

