/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.definitions;

import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.definitions.DefinitionBase;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;

public class BucketDefinition
extends DefinitionBase {
    public static final String KEY_BUCKETS = "buckets";
    public static final String KEY_TYPE = "type";
    public static final String KEY_MODE = "mode";
    public static final String KEY_PARAMETERS = "parameters";
    private final String _dataObjectType;
    private final AnyMap _parameters;

    public BucketDefinition(AnyMap bucket) throws InvalidDefinitionException {
        super(bucket);
        this._dataObjectType = AccessAny.getStringRequired((AnyMap)this._definitionMap, (String)KEY_TYPE);
        this._parameters = this._definitionMap.getMap(KEY_PARAMETERS);
    }

    public BucketDefinition(String name, String dataObjectType) {
        super(name);
        this._dataObjectType = dataObjectType;
        this._parameters = null;
    }

    public static BucketDefinition parseBucket(AnyMap bucketAny) throws InvalidDefinitionException {
        BucketDefinition workflow = null;
        try {
            workflow = new BucketDefinition(bucketAny);
        }
        catch (InvalidDefinitionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidDefinitionException("Invalid any structure", (Throwable)ex);
        }
        return workflow;
    }

    public String getDataObjectType() {
        return this._dataObjectType;
    }

    public AnyMap getParameters() {
        return AccessAny.cloneAnyMap((AnyMap)this._parameters);
    }

    public AnyMap toAny(boolean includingAdditionalAttributes) {
        try {
            AnyMap bucketAny = super.toAny(includingAdditionalAttributes);
            if (!includingAdditionalAttributes) {
                bucketAny.put(KEY_TYPE, this._dataObjectType);
                if (this._parameters != null) {
                    bucketAny.put(KEY_PARAMETERS, (Any)this._parameters);
                }
            }
            return bucketAny;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create Any object for bucket " + this._name, ex);
        }
    }
}

