/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.JobDependencyException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;

public class WorkflowRunControlHandler
extends AJobManagerHandler {
    public static final String CMD_CANCEL = "cancel";
    private static final int URIPARTS_COUNT = 4;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() == 4) {
            String jobName = (String)uriParts.get(0);
            String jobRunId = (String)uriParts.get(1);
            String workflowRunId = (String)uriParts.get(2);
            String command = (String)uriParts.get(3);
            if (!CMD_CANCEL.equals(command)) {
                throw new IllegalArgumentException("Invalid request URI, operation '" + command + "' not supported for job runs");
            }
            this.getJobRunEngine().cancelWorkflowRun(jobName, jobRunId, workflowRunId);
            return null;
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'");
    }

    @Override
    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalJobStateException) {
            return ((IllegalJobStateException)((Object)ex)).isJobRunGone() ? 410 : 400;
        }
        if (ex instanceof JobDependencyException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    protected int getSuccessStatus(String method, String requestUri) {
        return 200;
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isPostRequest(method);
    }
}

