/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.smila.common.definitions.ValueExpression;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;

public final class TaskParameterUtils {
    private static final DataFactory FACTORY = DataFactory.DEFAULT;

    private TaskParameterUtils() {
    }

    public static AnyMap mergeAndEvaluateParameters(AnyMap jobParameter, AnyMap workflowParameters, AnyMap actionParameters, String workerName) {
        AnyMap parameters = FACTORY.createAnyMap();
        TaskParameterUtils.mergeParameters(parameters, jobParameter, workerName);
        TaskParameterUtils.mergeParameters(parameters, workflowParameters, workerName);
        TaskParameterUtils.mergeParameters(parameters, actionParameters, null);
        return TaskParameterUtils.evaluateParameters(parameters);
    }

    private static void mergeParameters(AnyMap targetParameters, AnyMap parametersToMerge, String prefix) {
        if (parametersToMerge == null || parametersToMerge.isEmpty()) {
            return;
        }
        String checkPrefix = prefix == null ? null : String.valueOf(prefix) + ".";
        ArrayList<Map.Entry> prefixedParamaters = new ArrayList<Map.Entry>(parametersToMerge.size());
        for (Map.Entry entry : parametersToMerge.entrySet()) {
            targetParameters.put((String)entry.getKey(), (Any)entry.getValue());
            if (checkPrefix == null || !((String)entry.getKey()).startsWith(checkPrefix)) continue;
            prefixedParamaters.add(entry);
        }
        if (!prefixedParamaters.isEmpty()) {
            for (Map.Entry entry : prefixedParamaters) {
                targetParameters.put(((String)entry.getKey()).substring(checkPrefix.length()), (Any)entry.getValue());
            }
        }
    }

    public static AnyMap evaluateParameters(AnyMap map) {
        if (map == null) {
            return map;
        }
        AnyMap topLevelValues = FACTORY.createAnyMap();
        for (Map.Entry entry : map.entrySet()) {
            if (!((Any)entry.getValue()).isValue()) continue;
            topLevelValues.put((String)entry.getKey(), (Any)((Any)entry.getValue()).asValue());
        }
        return (AnyMap)TaskParameterUtils.evaluateParameter((Any)map, topLevelValues);
    }

    private static Any evaluateParameter(Any param, AnyMap topLevelValues) {
        if (param.isString()) {
            return FACTORY.createStringValue(new ValueExpression(param.asValue().asString()).evaluate(topLevelValues).toString());
        }
        if (param.isMap()) {
            AnyMap evaluatedMap = FACTORY.createAnyMap();
            for (Map.Entry entry : param.asMap().entrySet()) {
                evaluatedMap.put((String)entry.getKey(), TaskParameterUtils.evaluateParameter((Any)entry.getValue(), topLevelValues));
            }
            return evaluatedMap;
        }
        if (param.isSeq()) {
            AnySeq evaluatedSeq = FACTORY.createAnySeq();
            for (Any entry : param.asSeq()) {
                evaluatedSeq.add((Object)TaskParameterUtils.evaluateParameter(entry, topLevelValues));
            }
            return evaluatedSeq;
        }
        return param;
    }
}

