/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorBase;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.StoreObject;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;

public class DefaultTaskGenerator
extends TaskGeneratorBase {
    @Override
    public List<Task> createTasks(Map<String, List<BulkInfo>> changedInput, Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws TaskGeneratorException {
        if (changedInput.isEmpty()) {
            return Collections.singletonList(this.createInitialTask(outputBuckets, parameters, workerName));
        }
        ArrayList<Task> tasks = new ArrayList<Task>(changedInput.size());
        for (Map.Entry<String, List<BulkInfo>> inputSlot : changedInput.entrySet()) {
            String inputSlotName = inputSlot.getKey();
            List<BulkInfo> changedBulks = inputSlot.getValue();
            Bucket inputBucket = inputBuckets.get(inputSlotName);
            for (BulkInfo changedBulk : changedBulks) {
                String objectId = changedBulk.getObjectName();
                tasks.add(this.createSingleBulkTask(objectId, inputSlotName, inputBucket, outputBuckets, parameters, workerName));
            }
        }
        return tasks;
    }

    @Override
    public List<Task> createRunOnceTasks(Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws TaskGeneratorException {
        if (inputBuckets.size() != 1) {
            throw new TaskGeneratorException("Cannot create tasks for mode '" + JobRunMode.RUNONCE.name() + "' and worker '" + workerName + "'. The worker has not exactly one input bucket ('" + inputBuckets + "').");
        }
        try {
            return this.doCreateRunOnceTasks(inputBuckets, outputBuckets, parameters, workerName);
        }
        catch (Exception e) {
            throw new TaskGeneratorException("Cannot create tasks for mode '" + JobRunMode.RUNONCE.name() + "' and worker '" + workerName + "'.", e);
        }
    }

    protected List<Task> doCreateRunOnceTasks(Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws Exception {
        ArrayList<Task> taskList = new ArrayList<Task>();
        for (Map.Entry<String, Bucket> inputBucketEntry : inputBuckets.entrySet()) {
            String slotName = inputBucketEntry.getKey();
            Bucket bucket = inputBucketEntry.getValue();
            for (StoreObject objectInfo : ObjectStoreRetryUtil.retryGetStoreObjectInfos((ObjectStoreService)this._objectStore, (String)bucket.getStoreName(), (String)bucket.getDataObjectNamePrefix())) {
                if (objectInfo.getSize() <= 0L) continue;
                String objectId = objectInfo.getId();
                taskList.add(this.createSingleBulkTask(objectId, slotName, bucket, outputBuckets, parameters, workerName));
            }
        }
        return taskList;
    }

    protected Task createInitialTask(Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) {
        Task task = this.createTask(workerName, parameters);
        this.addOutputBulks(task, null, outputBuckets, parameters);
        return task;
    }

    @Override
    public List<Task> createCompletionTasks(Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws TaskGeneratorException {
        Task task = this.createCompletionTask(parameters, workerName);
        return Arrays.asList(task);
    }

    protected Task createCompletionTask(AnyMap parameters, String workerName) {
        Task task = this.createTask(workerName, parameters);
        task.getProperties().put("isCompletingTask", Boolean.TRUE.toString());
        return task;
    }
}

