/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.input;

import java.io.IOException;
import java.util.Map;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.objectstore.BadRequestException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskworker.input.Input;
import org.eclipse.smila.taskworker.input.StreamInput;
import org.eclipse.smila.taskworker.util.Counters;

public class RecordInput
extends Input {
    private static final IpcFactory IPCFACTORY = new BinaryFactory();
    private final StreamInput _streamInput;
    private IpcStreamReader _reader;
    private final IpcRecordReader _recordReader = new IpcRecordReader();
    private long _recordCount;

    public RecordInput(BulkInfo dataObject, ObjectStoreService objectStore) {
        super(dataObject, objectStore);
        this._streamInput = new StreamInput(dataObject, objectStore);
    }

    public Record getRecord() throws ObjectStoreException, IOException {
        IpcStreamReader reader = this.getStreamReader();
        long start = this.startTime();
        try {
            Record record = this._recordReader.readStream(reader);
            if (record != null) {
                ++this._recordCount;
            }
            Record record2 = record;
            return record2;
        }
        catch (IllegalStateException ex) {
            throw new BadRequestException("Error parsing BON stream to record", (Throwable)ex);
        }
        finally {
            this.timePerform(start);
        }
    }

    public IpcStreamReader getStreamReader() throws ObjectStoreException, IOException {
        if (this._reader == null) {
            long start = this.startTime();
            this._reader = IPCFACTORY.newStreamReader(this._streamInput.getStream());
            this.timeOpen(start);
        }
        return this._reader;
    }

    public long getRecordCount() {
        return this._recordCount;
    }

    public long getBytesRead() {
        return this._streamInput.getBytesRead();
    }

    @Override
    public Map<String, Number> getCounter() {
        Map<String, Number> counter = this._streamInput.getCounter();
        Counters.add(counter, "recordCount", this._recordCount);
        return counter;
    }

    @Override
    public void close() {
        if (this._reader != null) {
            try {
                this._reader.closeWithoutStream();
            }
            catch (IOException iOException) {}
        }
        this._streamInput.close();
    }

    public String toString() {
        return "RecordInput: store = " + this.getStoreName() + ", object = " + this.getObjectName();
    }
}

