/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.cocoa;

import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public class NSTableView
extends NSControl {
    public NSTableView() {
    }

    public NSTableView(long id2) {
        super(id2);
    }

    public NSTableView(id id2) {
        super(id2);
    }

    public void addTableColumn(NSTableColumn column) {
        OS.objc_msgSend(this.id, OS.sel_addTableColumn_, column != null ? column.id : 0L);
    }

    public boolean allowsColumnReordering() {
        return OS.objc_msgSend_bool(this.id, OS.sel_allowsColumnReordering);
    }

    public boolean canDragRowsWithIndexes(NSIndexSet rowIndexes, NSPoint mouseDownPoint) {
        return OS.objc_msgSend_bool(this.id, OS.sel_canDragRowsWithIndexes_atPoint_, rowIndexes != null ? rowIndexes.id : 0L, mouseDownPoint);
    }

    public long clickedColumn() {
        return OS.objc_msgSend(this.id, OS.sel_clickedColumn);
    }

    public long clickedRow() {
        return OS.objc_msgSend(this.id, OS.sel_clickedRow);
    }

    public long columnAtPoint(NSPoint point) {
        return OS.objc_msgSend(this.id, OS.sel_columnAtPoint_, point);
    }

    public NSIndexSet columnIndexesInRect(NSRect rect) {
        long result = OS.objc_msgSend(this.id, OS.sel_columnIndexesInRect_, rect);
        return result != 0L ? new NSIndexSet(result) : null;
    }

    public long columnWithIdentifier(NSString identifier) {
        return OS.objc_msgSend(this.id, OS.sel_columnWithIdentifier_, identifier != null ? identifier.id : 0L);
    }

    public void deselectAll(id sender) {
        OS.objc_msgSend(this.id, OS.sel_deselectAll_, sender != null ? sender.id : 0L);
    }

    public void deselectRow(long row) {
        OS.objc_msgSend(this.id, OS.sel_deselectRow_, row);
    }

    public NSImage dragImageForRowsWithIndexes(NSIndexSet dragRows, NSArray tableColumns, NSEvent dragEvent, long dragImageOffset) {
        long result = OS.objc_msgSend(this.id, OS.sel_dragImageForRowsWithIndexes_tableColumns_event_offset_, dragRows != null ? dragRows.id : 0L, tableColumns != null ? tableColumns.id : 0L, dragEvent != null ? dragEvent.id : 0L, dragImageOffset);
        return result != 0L ? new NSImage(result) : null;
    }

    public void drawBackgroundInClipRect(NSRect clipRect) {
        OS.objc_msgSend(this.id, OS.sel_drawBackgroundInClipRect_, clipRect);
    }

    public NSRect frameOfCellAtColumn(long column, long row) {
        NSRect result = new NSRect();
        OS.objc_msgSend_stret(result, this.id, OS.sel_frameOfCellAtColumn_row_, column, row);
        return result;
    }

    public NSTableHeaderView headerView() {
        long result = OS.objc_msgSend(this.id, OS.sel_headerView);
        return result != 0L ? new NSTableHeaderView(result) : null;
    }

    public void highlightSelectionInClipRect(NSRect clipRect) {
        OS.objc_msgSend(this.id, OS.sel_highlightSelectionInClipRect_, clipRect);
    }

    public NSSize intercellSpacing() {
        NSSize result = new NSSize();
        OS.objc_msgSend_stret(result, this.id, OS.sel_intercellSpacing);
        return result;
    }

    public boolean isRowSelected(long row) {
        return OS.objc_msgSend_bool(this.id, OS.sel_isRowSelected_, row);
    }

    public void moveColumn(long column, long newIndex) {
        OS.objc_msgSend(this.id, OS.sel_moveColumn_toColumn_, column, newIndex);
    }

    public void noteNumberOfRowsChanged() {
        OS.objc_msgSend(this.id, OS.sel_noteNumberOfRowsChanged);
    }

    public long numberOfColumns() {
        return OS.objc_msgSend(this.id, OS.sel_numberOfColumns);
    }

    public long numberOfRows() {
        return OS.objc_msgSend(this.id, OS.sel_numberOfRows);
    }

    public long numberOfSelectedRows() {
        return OS.objc_msgSend(this.id, OS.sel_numberOfSelectedRows);
    }

    public NSCell preparedCellAtColumn(long column, long row) {
        long result = OS.objc_msgSend(this.id, OS.sel_preparedCellAtColumn_row_, column, row);
        return result != 0L ? new NSCell(result) : null;
    }

    public NSRect rectOfColumn(long column) {
        NSRect result = new NSRect();
        OS.objc_msgSend_stret(result, this.id, OS.sel_rectOfColumn_, column);
        return result;
    }

    public NSRect rectOfRow(long row) {
        NSRect result = new NSRect();
        OS.objc_msgSend_stret(result, this.id, OS.sel_rectOfRow_, row);
        return result;
    }

    public void reloadData() {
        OS.objc_msgSend(this.id, OS.sel_reloadData);
    }

    public void removeTableColumn(NSTableColumn column) {
        OS.objc_msgSend(this.id, OS.sel_removeTableColumn_, column != null ? column.id : 0L);
    }

    public long rowAtPoint(NSPoint point) {
        return OS.objc_msgSend(this.id, OS.sel_rowAtPoint_, point);
    }

    public double rowHeight() {
        return OS.objc_msgSend_fpret(this.id, OS.sel_rowHeight);
    }

    public NSRange rowsInRect(NSRect rect) {
        NSRange result = new NSRange();
        OS.objc_msgSend_stret(result, this.id, OS.sel_rowsInRect_, rect);
        return result;
    }

    public void scrollColumnToVisible(long column) {
        OS.objc_msgSend(this.id, OS.sel_scrollColumnToVisible_, column);
    }

    public void scrollRowToVisible(long row) {
        OS.objc_msgSend(this.id, OS.sel_scrollRowToVisible_, row);
    }

    public void selectAll(id sender) {
        OS.objc_msgSend(this.id, OS.sel_selectAll_, sender != null ? sender.id : 0L);
    }

    public void selectRowIndexes(NSIndexSet indexes, boolean extend) {
        OS.objc_msgSend(this.id, OS.sel_selectRowIndexes_byExtendingSelection_, indexes != null ? indexes.id : 0L, extend);
    }

    public long selectedRow() {
        return OS.objc_msgSend(this.id, OS.sel_selectedRow);
    }

    public NSIndexSet selectedRowIndexes() {
        long result = OS.objc_msgSend(this.id, OS.sel_selectedRowIndexes);
        return result != 0L ? new NSIndexSet(result) : null;
    }

    public void setAllowsColumnReordering(boolean flag) {
        OS.objc_msgSend(this.id, OS.sel_setAllowsColumnReordering_, flag);
    }

    public void setAllowsMultipleSelection(boolean flag) {
        OS.objc_msgSend(this.id, OS.sel_setAllowsMultipleSelection_, flag);
    }

    public void setBackgroundColor(NSColor color) {
        OS.objc_msgSend(this.id, OS.sel_setBackgroundColor_, color != null ? color.id : 0L);
    }

    public void setColumnAutoresizingStyle(long style) {
        OS.objc_msgSend(this.id, OS.sel_setColumnAutoresizingStyle_, style);
    }

    public void setDataSource(id aSource) {
        OS.objc_msgSend(this.id, OS.sel_setDataSource_, aSource != null ? aSource.id : 0L);
    }

    public void setDelegate(id delegate) {
        OS.objc_msgSend(this.id, OS.sel_setDelegate_, delegate != null ? delegate.id : 0L);
    }

    public void setDoubleAction(long aSelector) {
        OS.objc_msgSend(this.id, OS.sel_setDoubleAction_, aSelector);
    }

    public void setDropRow(long row, long op) {
        OS.objc_msgSend(this.id, OS.sel_setDropRow_dropOperation_, row, op);
    }

    public void setGridStyleMask(long gridStyle) {
        OS.objc_msgSend(this.id, OS.sel_setGridStyleMask_, gridStyle);
    }

    public void setHeaderView(NSTableHeaderView headerView) {
        OS.objc_msgSend(this.id, OS.sel_setHeaderView_, headerView != null ? headerView.id : 0L);
    }

    public void setHighlightedTableColumn(NSTableColumn tc) {
        OS.objc_msgSend(this.id, OS.sel_setHighlightedTableColumn_, tc != null ? tc.id : 0L);
    }

    public void setIndicatorImage(NSImage anImage, NSTableColumn tc) {
        OS.objc_msgSend(this.id, OS.sel_setIndicatorImage_inTableColumn_, anImage != null ? anImage.id : 0L, tc != null ? tc.id : 0L);
    }

    public void setIntercellSpacing(NSSize aSize) {
        OS.objc_msgSend(this.id, OS.sel_setIntercellSpacing_, aSize);
    }

    public void setRowHeight(double rowHeight) {
        OS.objc_msgSend(this.id, OS.sel_setRowHeight_, rowHeight);
    }

    public void setUsesAlternatingRowBackgroundColors(boolean useAlternatingRowColors) {
        OS.objc_msgSend(this.id, OS.sel_setUsesAlternatingRowBackgroundColors_, useAlternatingRowColors);
    }

    public NSArray tableColumns() {
        long result = OS.objc_msgSend(this.id, OS.sel_tableColumns);
        return result != 0L ? new NSArray(result) : null;
    }

    public void tile() {
        OS.objc_msgSend(this.id, OS.sel_tile);
    }

    public boolean usesAlternatingRowBackgroundColors() {
        return OS.objc_msgSend_bool(this.id, OS.sel_usesAlternatingRowBackgroundColors);
    }

    public static long cellClass() {
        return OS.objc_msgSend(OS.class_NSTableView, OS.sel_cellClass);
    }

    public static void setCellClass(long factoryId) {
        OS.objc_msgSend(OS.class_NSTableView, OS.sel_setCellClass_, factoryId);
    }
}

