/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.taskworker.TaskContext;

public final class PropertyNameMapper {
    final AnyMap _mapping;
    final boolean _normalize;

    public PropertyNameMapper(AnyMap mapping) {
        this(mapping, false);
    }

    public PropertyNameMapper(AnyMap mapping, boolean normalize) {
        if (mapping == null) {
            throw new NullPointerException("Parameter mapping is null");
        }
        if (mapping.size() == 0) {
            throw new IllegalArgumentException("Parameter mapping is empty");
        }
        this._normalize = normalize;
        if (normalize) {
            this._mapping = mapping.getFactory().createAnyMap();
            for (Map.Entry entry : mapping.entrySet()) {
                this._mapping.put(((String)entry.getKey()).toUpperCase(Locale.ENGLISH), (Any)entry.getValue());
            }
        } else {
            this._mapping = mapping;
        }
    }

    public static PropertyNameMapper createFrom(TaskContext taskContext) {
        if (taskContext == null) {
            throw new NullPointerException("Parameter taskContext is null");
        }
        AnyMap taskParams = taskContext.getTaskParameters();
        return PropertyNameMapper.createFrom(taskParams);
    }

    public static PropertyNameMapper createFrom(AnyMap taskParams) {
        return PropertyNameMapper.createFrom(taskParams, false);
    }

    public static PropertyNameMapper createFrom(AnyMap taskParams, boolean normalize) {
        AnyMap mapping = taskParams.getMap("mapping");
        if (mapping == null) {
            throw new IllegalArgumentException("Parameter 'mapping is null");
        }
        if (mapping.size() == 0) {
            throw new IllegalArgumentException("Parameter 'mapping is empty");
        }
        return new PropertyNameMapper(mapping, normalize);
    }

    public List<String> get(String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (this._normalize) {
            key = key.toUpperCase(Locale.ENGLISH);
        }
        if (!this._mapping.containsKey((Object)key)) {
            throw new RuntimeException("No mapping for key '" + key + "' defined");
        }
        for (Any anyVal : (Any)this._mapping.get((Object)key)) {
            values.add(anyVal.asValue().asString());
        }
        return values;
    }

    public boolean containsMapping(String key) {
        if (this._normalize) {
            key = key.toUpperCase(Locale.ENGLISH);
        }
        return this._mapping.containsKey((Object)key);
    }

    public void mapNames(Record record, Set<String> crawlerPropertyNames) {
        AnyMap metadata = record.getMetadata();
        for (Map.Entry entry : this._mapping.entrySet()) {
            String key = (String)entry.getKey();
            boolean removeKey = true;
            for (Any mappedValue : (Any)entry.getValue()) {
                String mappedKey = mappedValue.asValue().asString();
                if (!mappedKey.equals(key)) {
                    if (metadata.containsKey((Object)key)) {
                        metadata.put(mappedKey, (Any)metadata.get((Object)key));
                        continue;
                    }
                    if (!record.hasAttachment(key)) continue;
                    record.setAttachment(mappedKey, record.getAttachmentAsBytes(key));
                    continue;
                }
                removeKey = false;
            }
            if (!removeKey) continue;
            if (metadata.containsKey((Object)key)) {
                metadata.remove((Object)key);
                continue;
            }
            if (!record.hasAttachment(key)) continue;
            record.removeAttachment(key);
        }
        if (crawlerPropertyNames != null) {
            for (String name : crawlerPropertyNames) {
                if (this.containsMapping(name)) continue;
                metadata.remove((Object)name);
                record.removeAttachment(name);
            }
        }
    }

    public AnySeq getMappingKeys() {
        AnySeq keys = DataFactory.DEFAULT.createAnySeq();
        for (String key : this._mapping.keySet()) {
            keys.add(key);
        }
        return keys;
    }
}

