/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.httphandler;

import java.util.List;
import java.util.UUID;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.utils.MaybeRecoverableException;

public abstract class AProcessHandler
extends JsonRequestHandler {
    private BlackboardFactory _blackboardFactory;

    public Object process(String method, String requestUri, Record inputRecord) throws Exception {
        try {
            if (inputRecord == null || inputRecord.getMetadata().isEmpty()) {
                throw new EmptyQueryException("Cannot process an empty record.");
            }
            String elementName = this.getElementName(requestUri);
            this.ensureQueryId(elementName, inputRecord);
            Blackboard blackboard = this._blackboardFactory.createTransientBlackboard();
            blackboard.setRecord(inputRecord);
            String[] resultIds = this.doProcess(elementName, blackboard, new String[]{inputRecord.getId()});
            Record result = null;
            if (resultIds != null && resultIds.length > 0) {
                result = blackboard.getRecord(resultIds[0]);
            }
            blackboard.unload();
            return result;
        }
        catch (BlackboardAccessException ex) {
            throw new ProcessingException("Blackboard error: ", ex);
        }
    }

    protected abstract String[] doProcess(String var1, Blackboard var2, String[] var3) throws BlackboardAccessException, ProcessingException;

    protected String getElementName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern " + this.getUriPattern());
    }

    public void setBlackboardFactory(BlackboardFactory factory) {
        this._blackboardFactory = factory;
    }

    public void unsetBlackboardFactory(BlackboardFactory factory) {
        if (this._blackboardFactory == factory) {
            this._blackboardFactory = null;
        }
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "POST".equals(method);
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof EmptyQueryException) {
            return 400;
        }
        if (ex instanceof MaybeRecoverableException && !((MaybeRecoverableException)ex).isRecoverable()) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureQueryId(String pipeletName, Record query) {
        if (query.getId() == null) {
            UUID uuid = null;
            AProcessHandler aProcessHandler = this;
            synchronized (aProcessHandler) {
                uuid = UUID.randomUUID();
            }
            query.setId(String.valueOf(pipeletName) + "-" + uuid.toString());
        }
    }

    protected static class EmptyQueryException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EmptyQueryException(String message) {
            super(message);
        }
    }
}

