/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.httphandler;

import java.util.List;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.scripting.ScriptNotFoundException;
import org.eclipse.smila.scripting.ScriptingEngine;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.eclipse.smila.utils.MaybeRecoverableException;

public class ScriptExecutionHandler
extends JsonRequestHandler {
    private ScriptingEngine _scriptingEngine;

    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetRequest(method) || this.isPostRequest(method);
    }

    protected boolean isGetRequest(String method) {
        return "GET".equals(method);
    }

    protected boolean isPostRequest(String method) {
        return "POST".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() == 1) {
            String scriptName = (String)uriParts.get(0);
            if (this.isGetRequest(method)) {
                AnySeq itemsSeq = this._scriptingEngine.listScripts();
                for (Any singleItem : itemsSeq) {
                    String itemName = singleItem.asMap().getStringValue("name");
                    if (!itemName.equals(scriptName)) continue;
                    singleItem.asMap().put("url", URLCreator.create((String)this.getRequestHost(exchange), (String)requestUri).toString());
                    return singleItem;
                }
                throw new ScriptNotFoundException("Unable to find " + scriptName);
            }
            return this._scriptingEngine.callScript(scriptName, inputRecord);
        }
        return null;
    }

    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof ScriptNotFoundException) {
            return 404;
        }
        if (ex instanceof MaybeRecoverableException && ((MaybeRecoverableException)ex).isRecoverable()) {
            return 503;
        }
        if (ex instanceof ScriptingEngineException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    public void setScriptingEngine(ScriptingEngine scriptingEngine) {
        this._scriptingEngine = scriptingEngine;
    }

    public void unsetScriptingEngine(ScriptingEngine scriptingEngine) {
        if (this._scriptingEngine == scriptingEngine) {
            this._scriptingEngine = null;
        }
    }
}

