/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.scripting.internal.AnyWrapper;
import org.eclipse.smila.scripting.internal.ObjectWrapperBase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class AnySeqWrapper
extends ObjectWrapperBase {
    private static final String PROP_LENGTH = "length";
    private static final String PROP_CONSTRUCTOR = "constructor";
    private final AnySeq _seq;

    public AnySeqWrapper(AnySeq seq, Scriptable parentScope) {
        super(parentScope);
        this.setPrototype(ScriptableObject.getArrayPrototype((Scriptable)parentScope));
        this._seq = seq;
    }

    public AnySeq unwrap() {
        return this._seq;
    }

    public String getClassName() {
        return "AnySeqWrapper";
    }

    public Object get(String name, Scriptable start) {
        switch (name) {
            case "length": {
                return this._seq.size();
            }
            case "constructor": {
                return null;
            }
        }
        throw Context.reportRuntimeError((String)("Getting string keys is not allowed for Sequences: " + name));
    }

    public Object get(int index, Scriptable start) {
        return AnyWrapper.wrapAny((Any)this._seq.get(index), this.getParentScope());
    }

    public boolean has(String name, Scriptable start) {
        return PROP_LENGTH.equals(name);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this._seq.size() && this._seq.get(index) != null;
    }

    public void put(String name, Scriptable start, Object value) {
        throw Context.reportRuntimeError((String)("Putting string keys it not allowed for Sequences: " + name));
    }

    public void put(int index, Scriptable start, Object value) {
        Any newElement = AnyWrapper.unwrapAny(value);
        if (index == this._seq.size()) {
            this._seq.add((Object)newElement);
        } else {
            this._seq.set(index, (Object)newElement);
        }
    }

    public void delete(String name) {
        throw Context.reportRuntimeError((String)("Deleting string keys is not allowed for Sequences: " + name));
    }

    public void delete(int index) {
        this._seq.remove(index);
    }

    public Object[] getIds() {
        Object[] ids = new Integer[this._seq.size()];
        int i = 0;
        while (i < this._seq.size()) {
            ids[i] = i;
            ++i;
        }
        return ids;
    }
}

