/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.importing.util.FilePathNormalizer;

public final class FileToRecordConverter {
    private final Log _log = LogFactory.getLog(this.getClass());
    private final DataFactory _factory;

    public FileToRecordConverter(DataFactory factory) {
        this._factory = factory;
    }

    public Record fileToRecord(Path file, String dataSource, boolean withContent) throws IOException {
        if (Files.isDirectory(file, new LinkOption[0])) {
            throw new IllegalArgumentException("parameter file is a directory");
        }
        Record record = this.createRecord(file, dataSource);
        this.addFileProperties(file, record);
        record.getMetadata().put("_deltaHash", Long.toString(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
        if (withContent) {
            this.addAttachment(record, "filePath", "fileContent");
        }
        return record;
    }

    public Record dirToRecord(Path directory, String dataSource) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("parameter directory is not a directory");
        }
        Record record = this.createRecord(directory, dataSource);
        record.getMetadata().put("fileFolder", directory.toRealPath(new LinkOption[0]).toString());
        return record;
    }

    public void addAttachment(Record record, String pathAttribute, String attachmentName) throws IOException {
        String path = record.getMetadata().getStringValue(pathAttribute);
        if (path == null) {
            throw new IllegalArgumentException("Record '" + record.getId() + "' does not contain attribute '" + pathAttribute + "'");
        }
        record.setAttachment(attachmentName, Files.readAllBytes(Paths.get(path, new String[0])));
    }

    private Record createRecord(Path file, String dataSource) throws IOException {
        return this._factory.createRecord(String.valueOf(dataSource) + ":" + file.toRealPath(new LinkOption[0]), dataSource);
    }

    private void addFileProperties(Path file, Record record) throws IOException {
        AnyMap metadata = record.getMetadata();
        metadata.put("fileName", file.getFileName().toString());
        metadata.put("filePath", FilePathNormalizer.getNormalizedPath((Path)file.toRealPath(new LinkOption[0])));
        if (file.getParent() != null) {
            metadata.put("fileFolder", FilePathNormalizer.getNormalizedPath((Path)file.getParent()));
        }
        metadata.put("fileSize", (Number)Files.size(file));
        Value lastModifiedDate = this._factory.createDateTimeValue(new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis()));
        metadata.put("fileLastModified", (Any)lastModifiedDate);
        metadata.put("fileExtension", FilenameUtils.getExtension((String)file.getFileName().toString()));
        boolean haveAclPermissions = this.getAclFilePermissions(file, metadata);
        if (!haveAclPermissions) {
            this.getPosixFilePermissions(file, metadata);
        }
    }

    private boolean getAclFilePermissions(Path file, AnyMap metadata) {
        try {
            List<AclEntry> accessControlList;
            AclFileAttributeView aclAttributeView = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
            if (aclAttributeView != null && (accessControlList = aclAttributeView.getAcl()) != null) {
                for (AclEntry ace : accessControlList) {
                    if (ace.permissions().contains((Object)AclEntryPermission.READ_DATA)) {
                        metadata.getSeq("fileReadAccess", true).add(ace.principal().getName());
                    }
                    if (!ace.permissions().contains((Object)AclEntryPermission.WRITE_DATA)) continue;
                    metadata.getSeq("fileWriteAccess", true).add(ace.principal().getName());
                }
                return true;
            }
        }
        catch (Exception e) {
            this._log.warn((Object)("Couldn't fetch access control list on file " + file), (Throwable)e);
        }
        return false;
    }

    private boolean getPosixFilePermissions(Path file, AnyMap metadata) {
        try {
            PosixFileAttributes posixFileAttributes;
            Set<PosixFilePermission> permissions;
            PosixFileAttributeView posixAttributeView = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixAttributeView != null && (permissions = (posixFileAttributes = posixAttributeView.readAttributes()).permissions()) != null) {
                String owner = posixFileAttributes.owner().getName();
                String group = posixFileAttributes.group().getName();
                for (PosixFilePermission permission : permissions) {
                    switch (permission) {
                        case OWNER_READ: {
                            metadata.getSeq("fileReadAccess", true).add(owner);
                            break;
                        }
                        case OWNER_WRITE: {
                            metadata.getSeq("fileWriteAccess", true).add(owner);
                            break;
                        }
                        case GROUP_READ: {
                            metadata.getSeq("fileReadAccess", true).add(group);
                            break;
                        }
                        case GROUP_WRITE: {
                            metadata.getSeq("fileWriteAccess", true).add(group);
                            break;
                        }
                        case OTHERS_READ: {
                            metadata.getSeq("fileReadAccess", true).add("_OTHERS_");
                            break;
                        }
                        case OTHERS_WRITE: {
                            metadata.getSeq("fileWriteAccess", true).add("_OTHERS_");
                            break;
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            this._log.warn((Object)("Couldn't fetch POSIX file attributes on file " + file), (Throwable)e);
        }
        return false;
    }
}

