/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.common.definitions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;

public final class NameValidator {
    public static final String VALID_NAME_EXPRESSION = "^[a-zA-Z0-9-_\\.]+$";
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9-_\\.]+$");

    private NameValidator() {
        throw new UnsupportedOperationException("Instantiation not allowed.");
    }

    public static void checkName(String name) throws InvalidDefinitionException {
        if (name == null) {
            throw new InvalidDefinitionException("A name must not be null.");
        }
        Matcher m = VALID_NAME_PATTERN.matcher(name);
        if (!m.matches()) {
            throw new InvalidDefinitionException("A name must match pattern ^[a-zA-Z0-9-_\\.]+$.");
        }
    }
}

