/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.jaxb;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.validation.Schema;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.utils.xml.SchemaUtils;
import org.xml.sax.SAXException;

public final class JaxbUtils {
    private JaxbUtils() {
    }

    public static Unmarshaller createValidatingUnmarshaller(JAXBContext context, Schema schema) throws JAXBException {
        if (schema == null) {
            throw new IllegalArgumentException("schema must not be null");
        }
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setSchema(schema);
        unmarshaller.setEventHandler(JaxbUtils.createValidationEventHandler());
        return unmarshaller;
    }

    public static Marshaller createValidatingMarshaller(JAXBContext context, Schema schema) throws JAXBException {
        if (schema == null) {
            throw new IllegalArgumentException("Schema is not found!");
        }
        Marshaller marshaller = context.createMarshaller();
        marshaller.setSchema(schema);
        marshaller.setEventHandler(JaxbUtils.createValidationEventHandler());
        return marshaller;
    }

    public static ValidationEventHandler createValidationEventHandler() {
        return new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent ve) {
                Log log = LogFactory.getLog(JaxbUtils.class);
                if (ve.getSeverity() != 0) {
                    ValidationEventLocator vel = ve.getLocator();
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Line:Col[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + "]:" + ve.getMessage()));
                    }
                    return false;
                }
                return true;
            }
        };
    }

    public static Unmarshaller createValidatingUnmarshaller(JAXBContext context, String bundleId, String resourcePath) throws JAXBException, SAXException {
        Schema schema = SchemaUtils.loadSchema(bundleId, resourcePath);
        return JaxbUtils.createValidatingUnmarshaller(context, schema);
    }

    public static Marshaller createValidatingMarshaller(JAXBContext context, String bundleId, String resourcePath) throws JAXBException, SAXException {
        Schema schema = SchemaUtils.loadSchema(bundleId, resourcePath);
        return JaxbUtils.createValidatingMarshaller(context, schema);
    }

    public static Object unmarshall(String bundleId, String contextPackage, ClassLoader classLoader, String schemaLocation, InputStream inputStream) throws JAXBException, SAXException {
        Schema schema = SchemaUtils.loadSchema(bundleId, schemaLocation);
        return JaxbUtils.unmarshall(contextPackage, classLoader, schema, inputStream);
    }

    public static Object unmarshall(String contextPackage, ClassLoader classLoader, Schema schema, InputStream inputStream) throws JAXBException, SAXException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)contextPackage, (ClassLoader)classLoader);
            Unmarshaller unmarshaller = JaxbUtils.createValidatingUnmarshaller(context, schema);
            Object o = unmarshaller.unmarshal(inputStream);
            Object object = JAXBElement.class.isAssignableFrom(o.getClass()) ? ((JAXBElement)o).getValue() : o;
            return object;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static void marshall(Object jaxbElement, String bundleId, String contextPackage, ClassLoader classLoader, String schemaPath, OutputStream outputStream) throws JAXBException, SAXException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)contextPackage, (ClassLoader)classLoader);
            Marshaller marshaller = JaxbUtils.createValidatingMarshaller(context, bundleId, schemaPath);
            marshaller.marshal(jaxbElement, outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public static void marshall(Object jaxbElement, String contextPackage, ClassLoader classLoader, Schema schema, OutputStream outputStream) throws JAXBException, SAXException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)contextPackage, (ClassLoader)classLoader);
            Marshaller marshaller = JaxbUtils.createValidatingMarshaller(context, schema);
            marshaller.marshal(jaxbElement, outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }
}

