/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlHelper {
    public static final DocumentBuilderFactory BUILDING_FACTORY = new DocumentBuilderFactoryImpl();
    public static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    public static final String XML_HEADER_UTF8 = "<?xml version=\"1.1\" encoding=\"UTF-8\"?>";

    static {
        BUILDING_FACTORY.setIgnoringComments(true);
        BUILDING_FACTORY.setNamespaceAware(true);
        BUILDING_FACTORY.setCoalescing(true);
        BUILDING_FACTORY.setIgnoringElementContentWhitespace(true);
    }

    private XmlHelper() {
    }

    public static String toString(Document document) {
        if (document == null) {
            return null;
        }
        return XmlHelper.toString(document, false);
    }

    public static String toString(Document document, boolean xmlDeclaration) {
        if (document == null) {
            return null;
        }
        StreamResult streamResult = new StreamResult(new StringWriter());
        XmlHelper.transform(document, streamResult, xmlDeclaration);
        String stringXml = streamResult.getWriter().toString();
        return stringXml;
    }

    public static byte[] toByteArray(Document document) {
        if (document == null) {
            return null;
        }
        try {
            String string = XML_HEADER_UTF8 + XmlHelper.toString(document);
            return string.getBytes("utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void transform(Document document, StreamResult streamResult, boolean xmlDeclaration) {
        Transformer transformer;
        if (document == null) {
            throw new IllegalArgumentException("document cannot be NULL!");
        }
        if (streamResult == null) {
            throw new IllegalArgumentException("streamResult cannot be NULL!");
        }
        try {
            transformer = TRANSFORMER_FACTORY.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("indent", "no");
        String strXmlDeclaration = xmlDeclaration ? "no" : "yes";
        transformer.setOutputProperty("omit-xml-declaration", strXmlDeclaration);
        DOMSource source = new DOMSource(document);
        try {
            transformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parse(String input) throws IOException, ParserConfigurationException, SAXException {
        if (input == null) {
            return null;
        }
        StringReader reader = new StringReader(input);
        InputSource inputSource = new InputSource(reader);
        DocumentBuilder documentBuilder = BUILDING_FACTORY.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    public static Document parse(byte[] input) throws IOException, ParserConfigurationException, SAXException {
        if (input == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(input);
        InputSource inputSource = new InputSource(stream);
        DocumentBuilder documentBuilder = BUILDING_FACTORY.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    public static Document newDocument() throws ParserConfigurationException {
        return BUILDING_FACTORY.newDocumentBuilder().newDocument();
    }

    public static Document newDocument(String rootName) throws ParserConfigurationException {
        Document document = XmlHelper.newDocument();
        Element child = document.createElement(rootName);
        document.appendChild(child);
        return document;
    }

    public static Element createElement(Node parent, String nodeName) {
        Element child = parent.getOwnerDocument().createElement(nodeName);
        parent.appendChild(child);
        return child;
    }

    public static Text createText(Node parent, String text) {
        Text child = parent.getOwnerDocument().createTextNode(text);
        parent.appendChild(child);
        return child;
    }
}

