/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.client.util;

import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public final class HttpClientUtil {
    private HttpClientUtil() {
    }

    public static DefaultHttpClient createInstance() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpClientUtil.disableRetries(client);
        return client;
    }

    public static DefaultHttpClient createInstance(ClientConnectionManager connectionManager) {
        DefaultHttpClient client = new DefaultHttpClient(connectionManager);
        HttpClientUtil.disableRetries(client);
        return client;
    }

    private static void disableRetries(DefaultHttpClient client) {
        DefaultHttpRequestRetryHandler retryhandler = new DefaultHttpRequestRetryHandler(0, false);
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)retryhandler);
    }

    public static ClientConnectionManager createThreadSafeConnectionManager() {
        return new PoolingClientConnectionManager();
    }

    public static ClientConnectionManager createThreadSafeConnectionManager(int maxTotalConnections, int maxConnectionsPerHost) {
        PoolingClientConnectionManager manager = new PoolingClientConnectionManager();
        manager.setMaxTotal(maxTotalConnections);
        manager.setDefaultMaxPerRoute(maxConnectionsPerHost);
        return manager;
    }
}

