/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RobotsTxt {
    private static final String TAG_AGENTLINE = "User-agent:";
    private static final String TAG_DISALLOWLINE = "Disallow:";
    private static final String ENCODING = "utf-8";
    private static final String SEPARATOR = "##";
    private final List<String> _disallows = new ArrayList<String>();

    public RobotsTxt() {
        this(false);
    }

    public RobotsTxt(boolean disallowAll) {
        if (disallowAll) {
            this._disallows.add("/");
        }
    }

    public RobotsTxt(String userAgent, InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName(ENCODING)));
        boolean foundAgentLine = false;
        boolean foundDisallowLines = false;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(TAG_AGENTLINE)) {
                if (foundDisallowLines) {
                    return;
                }
                if (foundAgentLine) continue;
                String agent = this.getLineValue(line, TAG_AGENTLINE.length());
                foundAgentLine = agent.equals("*") || userAgent.toLowerCase().contains(agent.toLowerCase());
                continue;
            }
            if (!foundAgentLine || !line.startsWith(TAG_DISALLOWLINE)) continue;
            String disallowPath = this.getLineValue(line, TAG_DISALLOWLINE.length());
            if (!disallowPath.isEmpty()) {
                this._disallows.add(URLDecoder.decode(disallowPath, ENCODING));
            }
            foundDisallowLines = true;
        }
    }

    public RobotsTxt(byte[] serialized) {
        String concatenatedDisallows = new String(serialized, Charset.forName(ENCODING));
        String[] split = concatenatedDisallows.split(SEPARATOR);
        this.addDisallows(split);
    }

    public RobotsTxt(String ... disallows) {
        this.addDisallows(disallows);
    }

    private void addDisallows(String ... disallows) {
        String[] stringArray = disallows;
        int n = disallows.length;
        int n2 = 0;
        while (n2 < n) {
            String disallow = stringArray[n2];
            if (!disallow.isEmpty()) {
                this._disallows.add(disallow);
            }
            ++n2;
        }
    }

    private String getLineValue(String line, int offset) {
        String value = line.substring(offset);
        int commentStart = value.indexOf(35);
        if (commentStart > 0) {
            value = value.substring(0, commentStart);
        }
        return value.trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAllowed(String path) {
        try {
            String disallow;
            String urlDecodedPath = URLDecoder.decode(path, ENCODING);
            if (!urlDecodedPath.startsWith("/")) {
                urlDecodedPath = "/" + urlDecodedPath;
            }
            Iterator<String> iterator = this._disallows.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!urlDecodedPath.startsWith(disallow = iterator.next()));
            return false;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public byte[] asBinary() {
        StringBuilder builder = new StringBuilder();
        for (String disallow : this._disallows) {
            builder.append(SEPARATOR).append(disallow);
        }
        return builder.toString().getBytes(Charset.forName(ENCODING));
    }
}

