/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.utils;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.eclipse.smila.utils.config.ConfigUtils;

public class WebCrawlerConfiguration {
    private static final String BUNDLE_NAME = "org.eclipse.smila.importing.crawler.web";
    private static final String CONFIG_FILE_NAME = "webcrawler.properties";
    private static final String PROPERTY_PROXY_HOST_NAME = "proxyHost";
    private static final String PROPERTY_PROXY_HOST_PORT = "proxyPort";
    private static final String PROPERTY_SOCKET_TIMEOUT = "socketTimeout";
    private static final String PROPERTY_USERAGENT = "userAgent";
    private static final String PROPERTY_ALLOW_ALL_ON_40X_FOR_ROBOTS = "allowAllOn40xForRobots";
    private final Log _log = LogFactory.getLog(this.getClass());
    private HttpHost _proxyHost;
    private Integer _socketTimeout = -1;
    private String _userAgent = "SMILA (http://wiki.eclipse.org/SMILA/UserAgent; smila-dev@eclipse.org)";
    private boolean _allowAllOn40xForRobots = false;

    public WebCrawlerConfiguration() {
        try {
            Properties webCrawlerProperties = ConfigUtils.getConfigProperties((String)BUNDLE_NAME, (String)CONFIG_FILE_NAME);
            String userAgentProperty = webCrawlerProperties.getProperty(PROPERTY_USERAGENT);
            if (userAgentProperty != null && (userAgentProperty = userAgentProperty.trim()).length() > 0) {
                this._userAgent = userAgentProperty;
            }
            if (webCrawlerProperties.containsKey(PROPERTY_PROXY_HOST_NAME)) {
                this._proxyHost = webCrawlerProperties.containsKey(PROPERTY_PROXY_HOST_PORT) ? new HttpHost(webCrawlerProperties.getProperty(PROPERTY_PROXY_HOST_NAME), Integer.valueOf(webCrawlerProperties.getProperty(PROPERTY_PROXY_HOST_PORT)).intValue()) : new HttpHost(webCrawlerProperties.getProperty(PROPERTY_PROXY_HOST_NAME));
            }
            if (webCrawlerProperties.containsKey(PROPERTY_SOCKET_TIMEOUT)) {
                this._socketTimeout = Integer.valueOf(webCrawlerProperties.getProperty(PROPERTY_SOCKET_TIMEOUT));
            }
            if (webCrawlerProperties.containsKey(PROPERTY_ALLOW_ALL_ON_40X_FOR_ROBOTS)) {
                this._allowAllOn40xForRobots = Boolean.valueOf(webCrawlerProperties.getProperty(PROPERTY_ALLOW_ALL_ON_40X_FOR_ROBOTS));
            }
        }
        catch (Exception e) {
            this._log.warn((Object)"Could not read web crawler properties, using default values.", (Throwable)e);
        }
    }

    public HttpHost getProxyHost() {
        return this._proxyHost;
    }

    public Integer getSocketTimeout() {
        return this._socketTimeout;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public boolean isAllowAllOn40xForRobots() {
        return this._allowAllOn40xForRobots;
    }
}

