/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.memdao.BpelDAOConnectionImpl;
import org.apache.ode.bpel.memdao.CorrelatorDaoImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessDaoImpl
extends DaoBaseImpl
implements ProcessDAO {
    private static final Log __log = LogFactory.getLog(ProcessDaoImpl.class);
    public static long TIME_TO_LIVE = 120000L;
    private QName _processId;
    private QName _type;
    private long _version;
    final Map<String, CorrelatorDaoImpl> _correlators = new ConcurrentHashMap<String, CorrelatorDaoImpl>();
    protected final Map<Long, ProcessInstanceDAO> _instances = new ConcurrentHashMap<Long, ProcessInstanceDAO>();
    protected final Map<Long, Long> _instancesAge = new ConcurrentHashMap<Long, Long>();
    protected final Map<Integer, PartnerLinkDAO> _plinks = new ConcurrentHashMap<Integer, PartnerLinkDAO>();
    private Map<QName, ProcessDaoImpl> _store;
    private BpelDAOConnectionImpl _conn;
    private int _executionCount = 0;
    private Collection<Long> _instancesToRemove = new ConcurrentLinkedQueue<Long>();
    private static volatile long _lastRemoval = 0L;
    private String _guid;

    public ProcessDaoImpl(BpelDAOConnectionImpl bpelDAOConnectionImpl, Map<QName, ProcessDaoImpl> map, QName qName, QName qName2, String string, long l) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Creating ProcessDao object for process \"" + qName + "\"."));
        }
        this._guid = string;
        this._conn = bpelDAOConnectionImpl;
        this._store = map;
        this._processId = qName;
        this._type = qName2;
        this._version = l;
    }

    public QName getProcessId() {
        return this._processId;
    }

    public CorrelatorDAO getCorrelator(String string) {
        CorrelatorDAO correlatorDAO = this._correlators.get(string);
        if (correlatorDAO == null) {
            throw new IllegalArgumentException("no such correlator: " + string);
        }
        return correlatorDAO;
    }

    public Collection<CorrelatorDAO> getCorrelators() {
        Collection<CorrelatorDaoImpl> collection = this._correlators.values();
        return Collections.unmodifiableCollection(collection);
    }

    public void removeRoutes(String string, ProcessInstanceDAO processInstanceDAO) {
        for (CorrelatorDaoImpl correlatorDaoImpl : this._correlators.values()) {
            correlatorDaoImpl.removeRoutes(string, processInstanceDAO);
        }
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO correlatorDAO) {
        final ProcessInstanceDaoImpl processInstanceDaoImpl = new ProcessInstanceDaoImpl(this._conn, this, correlatorDAO);
        this._conn.defer(new Runnable(){

            public void run() {
                ProcessDaoImpl.this._instances.put(processInstanceDaoImpl.getInstanceId(), processInstanceDaoImpl);
                ProcessDaoImpl.this._instancesAge.put(processInstanceDaoImpl.getInstanceId(), System.currentTimeMillis());
            }
        });
        this.discardOldInstances();
        final Long l = processInstanceDaoImpl.getInstanceId();
        this._conn.onRollback(new Runnable(){

            public void run() {
                ProcessDaoImpl.this._instances.remove(l);
                ProcessDaoImpl.this._instancesAge.remove(l);
            }
        });
        ++this._executionCount;
        return processInstanceDaoImpl;
    }

    public ProcessInstanceDAO getInstance(Long l) {
        return this._instances.get(l);
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey correlationKey) {
        return this.findInstance(correlationKey, true);
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey correlationKey, boolean bl) {
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>();
        for (ProcessInstanceDAO processInstanceDAO : this._instances.values()) {
            for (CorrelationSetDAO correlationSetDAO : processInstanceDAO.getCorrelationSets()) {
                CorrelationKey correlationKey2 = correlationSetDAO.getValue();
                if (correlationKey2 == null || !correlationKey2.equals((Object)correlationKey)) continue;
                arrayList.add(processInstanceDAO);
            }
        }
        return arrayList;
    }

    public void instanceCompleted(ProcessInstanceDAO processInstanceDAO) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Removing completed process instance " + processInstanceDAO.getInstanceId() + " from in-memory store."));
        }
        this._instancesAge.remove(processInstanceDAO.getInstanceId());
        ProcessInstanceDAO processInstanceDAO2 = this._instances.remove(processInstanceDAO.getInstanceId());
        if (processInstanceDAO2 == null) {
            ArrayList<Long> arrayList = new ArrayList<Long>(this._instancesToRemove);
            for (Long l : arrayList) {
                this._instances.remove(l);
            }
            this._instancesToRemove.removeAll(arrayList);
            this._instancesToRemove.add(processInstanceDAO.getInstanceId());
        }
    }

    public void delete() {
        this._store.remove(this._processId);
    }

    public long getVersion() {
        return this._version;
    }

    public String getDeployer() {
        return "nobody";
    }

    public QName getType() {
        return this._type;
    }

    public CorrelatorDAO addCorrelator(String string) {
        CorrelatorDaoImpl correlatorDaoImpl = new CorrelatorDaoImpl(string, this._conn);
        this._correlators.put(correlatorDaoImpl.getCorrelatorId(), correlatorDaoImpl);
        return correlatorDaoImpl;
    }

    public void update() {
    }

    public int getNumInstances() {
        return this._executionCount;
    }

    public ProcessInstanceDAO getInstanceWithLock(Long l) {
        return this.getInstance(l);
    }

    public int getActivityFailureCount() {
        return 0;
    }

    public Date getActivityFailureDateTime() {
        return null;
    }

    public String getGuid() {
        return this._guid;
    }

    public void setGuid(String string) {
        this._guid = string;
    }

    void discardOldInstances() {
        long l = System.currentTimeMillis();
        if (l > _lastRemoval + TIME_TO_LIVE / 4L) {
            _lastRemoval = l;
            Object[] objectArray = this._instancesAge.keySet().toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                Long l2 = (Long)objectArray[i];
                Long l3 = this._instancesAge.get(l2);
                if (l3 == null || l - l3 <= TIME_TO_LIVE) continue;
                __log.warn((Object)("Discarding in-memory instance " + l2 + " because it exceeded its time-to-live: " + this._instances.get(l2)));
                this._instances.remove(l2);
                this._instancesAge.remove(l2);
            }
        }
    }
}

