/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.utils.config.ConfigUtils;

public class SolrConfig {
    private static final String BUNDLE = "org.eclipse.smila.solr";
    private static final String DEFAULT_CONFIG_FILE = "solr-config.json";
    private static final String MODE = "mode";
    public static final String ID_FIELDS = "idFields";
    public static final String ID_FIELD_DEFAULT = "_recordid";
    public static final String REST_URI = "restUri";
    public static final String RESPONSE_PARSER_ERRORS = "ResponseParser.errors";
    public static final String FETCH_FACET_FIELD_TYPE = "ResponseParser.fetchFacetFieldType";
    public static final String ZK_HOST = "CloudSolrServer.zkHost";
    public static final String UPDATES_TO_LEADERS = "CloudSolrServer.updatesToLeaders";
    public static final boolean UPDATES_TO_LEADERS_DEFAULT = true;
    public static final String BASE_URL = "HttpSolrServer.baseUrl";
    public static final String SOLR_HOME = "EmbeddedSolrServer.solrHome";
    public static final String SERVER_URLS = "LoadBalancedSolrServer.serverUrls";
    private final Log _log = LogFactory.getLog(this.getClass());
    protected final AnyMap _config;

    public SolrConfig() {
        this(DEFAULT_CONFIG_FILE);
    }

    public SolrConfig(String configPath) {
        this._config = this.loadConfiguration(configPath);
    }

    public SolrConfig(AnyMap config) {
        this._config = config;
    }

    public AnyMap getConfigMap() {
        return this._config;
    }

    public Mode getMode() {
        String mode = this._config.getStringValue(MODE);
        if (mode == null) {
            throw new NullArgumentException(MODE);
        }
        try {
            return Mode.get(mode);
        }
        catch (Exception exception) {
            String message = String.format("Mode must be one of [%s].", StringUtils.join((Object[])Mode.values(), (String)", "));
            throw new IllegalArgumentException(message, exception);
        }
    }

    public String getIdField(String index) {
        AnyMap idFields = this._config.getMap(ID_FIELDS);
        if (idFields != null) {
            String id = idFields.getStringValue(index);
            return id != null ? id : ID_FIELD_DEFAULT;
        }
        return ID_FIELD_DEFAULT;
    }

    public String getRestUri() {
        String restUri = this._config.getStringValue(REST_URI);
        if (StringUtils.isBlank((String)restUri)) {
            throw new NullArgumentException(REST_URI);
        }
        return restUri;
    }

    public SolrConstants.Errors getResponseParserErrors() {
        return this.getErrors(RESPONSE_PARSER_ERRORS);
    }

    public boolean isFetchFacetFieldType() {
        Boolean fetchFacetFieldType = this._config.getBooleanValue(FETCH_FACET_FIELD_TYPE);
        return fetchFacetFieldType != null ? fetchFacetFieldType : false;
    }

    public String getCloudSolrServerZkHost() {
        String zkHost = this._config.getStringValue(ZK_HOST);
        if (StringUtils.isBlank((String)zkHost)) {
            throw new NullArgumentException(ZK_HOST);
        }
        return zkHost;
    }

    public boolean getCloudSolrServerUpdatesToLeaders() {
        Boolean updatesToLeaders = this._config.getBooleanValue(UPDATES_TO_LEADERS);
        return updatesToLeaders != null ? updatesToLeaders : true;
    }

    public String getHttpSolrServerBaseUrl() {
        String baseUrl = this._config.getStringValue(BASE_URL);
        if (StringUtils.isBlank((String)baseUrl)) {
            throw new NullArgumentException(BASE_URL);
        }
        return baseUrl;
    }

    public String getEmbeddedSolrServerSolrHome() {
        String solrHome = this._config.getStringValue(SOLR_HOME);
        if (StringUtils.isBlank((String)solrHome)) {
            throw new NullArgumentException(SOLR_HOME);
        }
        return solrHome;
    }

    public String[] getLoadBalancedSolrServerServerUrls() {
        AnySeq serverUrls = this._config.getSeq(SERVER_URLS);
        if (serverUrls == null) {
            throw new NullArgumentException(SERVER_URLS);
        }
        return serverUrls.asStrings().toArray(new String[serverUrls.size()]);
    }

    private AnyMap loadConfiguration(String configPath) {
        Any any;
        block2: {
            InputStream stream = ConfigUtils.getConfigStream((String)BUNDLE, (String)configPath);
            IpcAnyReader reader = new IpcAnyReader();
            any = null;
            try {
                any = reader.readJsonStream(stream);
            }
            catch (IOException exception) {
                if (!this._log.isFatalEnabled()) break block2;
                this._log.fatal((Object)"Unable to load Solr configuration.", (Throwable)exception);
            }
        }
        return (AnyMap)any;
    }

    private SolrConstants.Errors getErrors(String clazz) {
        String errors = this._config.getStringValue(clazz);
        try {
            return SolrConstants.Errors.get(errors);
        }
        catch (Exception exception) {
            return SolrConstants.Errors.THROW;
        }
    }

    public static enum Mode {
        CLOUD,
        EMBEDDED,
        HTTP;


        public static Mode get(String label) {
            return Mode.valueOf(label.toUpperCase());
        }
    }
}

