/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.administration;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;

public class FieldInfo {
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String DEFAULT = "default";
    public static final String INDEXED = "indexed";
    public static final String STORED = "stored";
    public static final String DOC_VALUES = "docValues";
    public static final String SORT_MISSING_FIRST = "sortMissingFirst";
    public static final String SORT_MISSING_LAST = "sortMissingLast";
    public static final String MULTIVALUED = "multiValued";
    public static final String OMIT_NORMS = "omitNorms";
    public static final String OMIT_TERM_FREQ_AND_POSITION = "omitTermFreqAndPosition";
    public static final String OMIT_POSITION = "omitPosition";
    public static final String TERM_VECTORS = "termVectors";
    public static final String TERM_POSITIONS = "termPositions";
    public static final String TERM_OFFSETS = "termOffsets";
    public static final String REQUIRED = "required";
    private final AnyMap _field;
    public static final String[] LONGS = new String[]{"int", "short", "long"};
    public static final String[] DOUBLES = new String[]{"float", "double"};
    public static final String[] DATES = new String[]{"date"};
    public static final String[] BOOLEANS = new String[]{"boolean"};

    public FieldInfo(AnyMap field) {
        this._field = field;
    }

    public String getName() {
        return this._field.getStringValue(NAME);
    }

    public String getType() {
        return this._field.getStringValue(TYPE);
    }

    public String getDefault() {
        return this._field.getStringValue(DEFAULT);
    }

    public Boolean isIndexed() {
        return this._field.getBooleanValue(INDEXED);
    }

    public Boolean isStored() {
        return this._field.getBooleanValue(STORED);
    }

    public Boolean isDocValues() {
        return this._field.getBooleanValue(DOC_VALUES);
    }

    public Boolean isSortMissingFirst() {
        return this._field.getBooleanValue(SORT_MISSING_FIRST);
    }

    public Boolean isSortMissingLast() {
        return this._field.getBooleanValue(SORT_MISSING_LAST);
    }

    public Boolean isMultiValued() {
        return this._field.getBooleanValue(MULTIVALUED);
    }

    public Boolean isOmitNorms() {
        return this._field.getBooleanValue(OMIT_NORMS);
    }

    public Boolean isOmitTermFreqAndPosition() {
        return this._field.getBooleanValue(OMIT_TERM_FREQ_AND_POSITION);
    }

    public Boolean isOmitPositions() {
        return this._field.getBooleanValue(OMIT_POSITION);
    }

    public Boolean isTermVectors() {
        return this._field.getBooleanValue(TERM_VECTORS);
    }

    public Boolean isTermPositions() {
        return this._field.getBooleanValue(TERM_POSITIONS);
    }

    public Boolean isTermOffsets() {
        return this._field.getBooleanValue(TERM_OFFSETS);
    }

    public Boolean isRequired() {
        return this._field.getBooleanValue(REQUIRED);
    }

    public Any.ValueType getTypeAsValueType() {
        String type = this.getType();
        if (ArrayUtils.contains((Object[])LONGS, (Object)type)) {
            return Any.ValueType.LONG;
        }
        if (ArrayUtils.contains((Object[])DOUBLES, (Object)type)) {
            return Any.ValueType.DOUBLE;
        }
        if (ArrayUtils.contains((Object[])DATES, (Object)type)) {
            return Any.ValueType.DATETIME;
        }
        if (ArrayUtils.contains((Object[])BOOLEANS, (Object)type)) {
            return Any.ValueType.BOOLEAN;
        }
        return Any.ValueType.STRING;
    }
}

