/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.administration;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;

public class SchemaRequest {
    final HttpClient _httpClient;
    final String _restUri;

    public SchemaRequest(HttpClient httpClient, String restUri) {
        this._httpClient = httpClient;
        this._restUri = restUri;
    }

    public Any getAsAny(String index, Map<String, String[]> params, List<String> path) throws HttpException, IOException {
        String uri = this.getUri(index, path);
        GetMethod method = new GetMethod(uri);
        NameValuePair[] nameValuePairs = this.getAsNameValuePairs(params);
        method.setQueryString(nameValuePairs);
        this._httpClient.executeMethod((HttpMethod)method);
        InputStream response = method.getResponseBodyAsStream();
        return new IpcAnyReader().readJsonStream(response);
    }

    private String getUri(String index, List<String> path) {
        StrBuilder uri = new StrBuilder(this._restUri);
        path.add(0, index);
        uri.appendWithSeparators(path, "/");
        return uri.toString();
    }

    private NameValuePair[] getAsNameValuePairs(Map<String, String[]> params) {
        NameValuePair[] nameValuePairs = new NameValuePair[params.size()];
        int index = 0;
        for (Map.Entry<String, String[]> param : params.entrySet()) {
            nameValuePairs[index] = new NameValuePair(param.getKey(), param.getValue()[0]);
            ++index;
        }
        return nameValuePairs;
    }
}

