/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.httphandler;

import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.solr.SolrOperationService;

public class SchemaHandler
extends JsonRequestHandler {
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private SolrOperationService _operationService;

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        Any result = null;
        switch (method) {
            case "GET": {
                String index = this.getIndex(requestUri);
                Map params = exchange.getParameterMap();
                List<String> path = this.getPath(requestUri);
                result = this._operationService.processSchemaRequest(index, params, path);
                break;
            }
            default: {
                throw new UnsupportedMethodException("HttpMethod: [GET]");
            }
        }
        return result;
    }

    private String getIndex(String requestUri) {
        String staticUriParts = this.getStaticUriParts(requestUri);
        return StringUtils.remove((String)staticUriParts, (String)"/");
    }

    private List<String> getPath(String requestUri) throws URISyntaxException {
        List dynamicUriParts = this.getDynamicUriParts(requestUri);
        Iterator iterator = dynamicUriParts.iterator();
        while (iterator.hasNext()) {
            if (!StringUtils.isBlank((String)((String)iterator.next()))) continue;
            iterator.remove();
        }
        return dynamicUriParts;
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method);
    }

    protected void bindSolrOperationService(SolrOperationService operationService) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Bind SolrOperationService...");
        }
        this._operationService = operationService;
    }

    protected void unbindSolrOperationService(SolrOperationService operationService) {
        if (this._operationService == operationService) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Unbind SolrOperationService...");
            }
            this._operationService = null;
        }
    }
}

