/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.params;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.params.SolrParams;

public class SearchParams
extends SolrParams {
    public static final String SEARCH = "search";
    public static final String HTTP_METHOD = "method";
    static final String ERROR_HANDLING = "ErrorHandling";
    public static final String QUERY_LOGGING = "queryLogging";

    public SearchParams(AnyMap configuration) {
        super(configuration);
    }

    public SearchParams(Blackboard blackboard) {
        super(blackboard);
    }

    public SearchParams(Blackboard blackboard, AnyMap configuration) {
        super(blackboard, configuration);
    }

    public SearchParams(Blackboard blackboard, AnyMap configuration, String recordId) {
        super(blackboard, configuration, recordId);
    }

    public SearchParams(Blackboard blackboard, String recordId) {
        super(blackboard, recordId);
    }

    public SolrRequest.METHOD getMethod() {
        String method = this.getSolrParamAsString(SEARCH, HTTP_METHOD);
        if (method == null) {
            return SolrRequest.METHOD.POST;
        }
        try {
            return SolrRequest.METHOD.valueOf((String)method);
        }
        catch (Exception exception) {
            String message = String.format("Operation must be one of [%s].", StringUtils.join((Object[])SolrRequest.METHOD.values(), (String)", "));
            throw new IllegalArgumentException(message, exception);
        }
    }

    public SolrConstants.ErrorHandling getErrorHandling() {
        String handling = this.getSolrParamAsString(SEARCH, ERROR_HANDLING);
        if (handling == null) {
            return SolrConstants.ErrorHandling.IGNORE;
        }
        try {
            return SolrConstants.ErrorHandling.get(handling);
        }
        catch (Exception exception) {
            String message = String.format("ErrorHandling must be one of [%s].", StringUtils.join((Object[])SolrConstants.ErrorHandling.values(), (String)", "));
            throw new IllegalArgumentException(message, exception);
        }
    }

    public SolrConstants.QueryLogging getQueryLogging() {
        String logging = this.getSolrParamAsString(SEARCH, QUERY_LOGGING);
        if (logging == null) {
            return SolrConstants.QueryLogging.NONE;
        }
        try {
            return SolrConstants.QueryLogging.get(logging);
        }
        catch (Exception exception) {
            String message = String.format("QueryHandling must be one of [%s].", StringUtils.join((Object[])SolrConstants.QueryLogging.values(), (String)", "));
            throw new IllegalArgumentException(message, exception);
        }
    }
}

