/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.solr.SolrConfig;

public abstract class SolrServers {
    private final Map<String, SolrServer> _cache = new HashMap<String, SolrServer>();
    private final SolrConfig _config;

    public SolrServers(SolrConfig config) {
        this._config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrServer getServer(String index) throws SolrServerException {
        SolrServer server = this._cache.get(index);
        if (server == null) {
            Map<String, SolrServer> map = this._cache;
            synchronized (map) {
                try {
                    server = this.createServer(index);
                }
                catch (Exception exception) {
                    throw new SolrServerException("Unable to create solr server for name: " + index, (Throwable)exception);
                }
                this._cache.put(index, server);
            }
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrServer getServer() throws SolrServerException {
        SolrServer server = this._cache.get(null);
        if (server == null) {
            Map<String, SolrServer> map = this._cache;
            synchronized (map) {
                try {
                    server = this.createServer();
                }
                catch (Exception exception) {
                    throw new SolrServerException("Unable to create solr server", (Throwable)exception);
                }
                this._cache.put(null, server);
            }
        }
        return server;
    }

    public void shutdown() {
        for (SolrServer solrServer : this._cache.values()) {
            solrServer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(String name) {
        Map<String, SolrServer> map = this._cache;
        synchronized (map) {
            this._cache.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<String, SolrServer> map = this._cache;
        synchronized (map) {
            this._cache.clear();
        }
    }

    protected SolrConfig getConfig() {
        return this._config;
    }

    protected abstract SolrServer createServer(String var1) throws Exception;

    protected abstract SolrServer createServer() throws Exception;
}

