/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.service;

import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.solr.server.CloudServers;
import org.eclipse.smila.solr.server.EmbeddedServers;
import org.eclipse.smila.solr.server.HttpServers;
import org.eclipse.smila.solr.server.SolrServers;
import org.osgi.service.component.ComponentContext;

public class SolrServerServiceImpl
implements SolrServerService {
    private final Log _log = LogFactory.getLog(this.getClass());
    private SolrConfig _config = new SolrConfig();
    private SolrServers _servers;

    @Override
    public SolrServer getServer(String index) throws SolrServerException {
        return this._servers.getServer(index);
    }

    @Override
    public SolrServer getServer() throws SolrServerException {
        return this._servers.getServer();
    }

    @Override
    public SolrConfig getConfig() {
        return this._config;
    }

    @Override
    public SolrConfig reloadConfig() {
        this._servers.clearCache();
        this._config = new SolrConfig();
        return this._config;
    }

    protected void activate(ComponentContext context) {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)"OSGI DS: Activate SolrServerService...");
        }
        SolrConfig.Mode mode = this._config.getMode();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Set mode: " + mode.toString()));
        }
        switch (mode) {
            case CLOUD: {
                this._servers = new CloudServers(this._config);
                break;
            }
            case EMBEDDED: {
                this._servers = new EmbeddedServers(this._config);
                break;
            }
            case HTTP: {
                this._servers = new HttpServers(this._config);
                break;
            }
            default: {
                throw new NotImplementedException(mode.toString());
            }
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"SolrServerService activated successfully");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)"OSGI DS: Deactivate SolrServerService...");
        }
        if (this._servers != null) {
            this._servers.shutdown();
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"SolrServerService deactivated successfully");
        }
    }
}

