/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;

public class ODEAxisServiceDispatcher
extends AbstractDispatcher {
    public static final String NAME = "ODEAxisServiceDispatcher";
    private static final Log log = LogFactory.getLog(ODEAxisServiceDispatcher.class);
    QName operationName = null;

    public AxisOperation findOperation(AxisService axisService, MessageContext messageContext) throws AxisFault {
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference endpointReference = messageContext.getTo();
        if (endpointReference != null) {
            String string;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for Service using target endpoint address : " + endpointReference.getAddress()));
            }
            if ((string = this.parseRequestURLForService(endpointReference.getAddress())) != null) {
                Policy policy;
                AxisConfiguration axisConfiguration = messageContext.getConfigurationContext().getAxisConfiguration();
                AxisService axisService = axisConfiguration.getService(string);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found service in registry from name " + string + ": " + axisService));
                }
                if ((policy = PolicyUtil.getMergedPolicy(new ArrayList(axisService.getPolicySubject().getAttachedPolicyComponents()), (AxisService)axisService)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Apply policy: " + policy.getName()));
                    }
                    messageContext.setProperty("rampartPolicy", (Object)policy);
                }
                return axisService;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)"No service has been found!");
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    protected String parseRequestURLForService(String string) {
        int n = string.indexOf("/processes/");
        if (-1 != n) {
            int n2 = n + "/processes/".length();
            if (string.length() > n2 + 1) {
                String string2 = string.substring(n2);
                int n3 = string2.indexOf(63);
                if (n3 > 0) {
                    string2 = string2.substring(0, n3);
                }
                return string2;
            }
        }
        return null;
    }
}

