/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.httpbinding.HttpHelper;
import org.apache.ode.axis2.util.URLEncodedTransformer;
import org.apache.ode.axis2.util.UrlReplacementTransformer;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.il.epr.MutableEndpoint;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.http.HttpUtils;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodConverter {
    private static final Log log = LogFactory.getLog(HttpMethodConverter.class);
    protected static final Messages msgs = (Messages)Messages.getMessages(Messages.class);
    protected Definition definition;
    protected Binding binding;
    protected QName serviceName;
    protected String portName;

    public HttpMethodConverter(Definition definition, QName qName, String string) {
        this.definition = definition;
        this.binding = definition.getService(qName).getPort(string).getBinding();
        this.serviceName = qName;
        this.portName = string;
    }

    public HttpMethod createHttpRequest(PartnerRoleMessageExchange partnerRoleMessageExchange, HttpParams httpParams) throws UnsupportedEncodingException {
        Operation operation = partnerRoleMessageExchange.getOperation();
        BindingOperation bindingOperation = this.binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName());
        Element element = partnerRoleMessageExchange.getRequest().getMessage();
        Message message = operation.getInput().getMessage();
        String string = ((MutableEndpoint)partnerRoleMessageExchange.getEndpointReference()).getUrl();
        Map<String, Element> map = this.extractPartElements(message, element);
        String string2 = WsdlUtils.resolveVerb((Binding)this.binding, (BindingOperation)bindingOperation);
        HttpMethod httpMethod = this.prepareHttpMethod(bindingOperation, string2, map, partnerRoleMessageExchange.getRequest().getHeaderParts(), string, httpParams);
        return httpMethod;
    }

    protected HttpMethod prepareHttpMethod(BindingOperation bindingOperation, String string, Map<String, Element> map, Map<String, Node> map2, String string2, HttpParams httpParams) throws UnsupportedEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing http request...");
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        HTTPOperation hTTPOperation = (HTTPOperation)WsdlUtils.getOperationExtension((BindingOperation)bindingOperation);
        MIMEContent mIMEContent = WsdlUtils.getMimeContent((List)bindingInput.getExtensibilityElements());
        String string3 = mIMEContent == null ? null : mIMEContent.getType();
        boolean bl = WsdlUtils.useUrlEncoded((BindingInput)bindingInput) || "application/x-www-form-urlencoded".equalsIgnoreCase(string3);
        boolean bl2 = WsdlUtils.useUrlReplacement((BindingInput)bindingInput);
        GetMethod getMethod = null;
        String string4 = hTTPOperation.getLocationURI();
        String string5 = null;
        String string6 = null;
        String string7 = string2;
        if (StringUtils.isNotEmpty((String)string4)) {
            string7 = string7 + (string7.endsWith("/") || string4.startsWith("/") ? "" : "/") + string4;
        }
        if (bl2) {
            string7 = new UrlReplacementTransformer().transform(string7, map);
        } else if (bl) {
            string6 = new URLEncodedTransformer().transform(map);
        }
        if ("GET".equalsIgnoreCase(string) || "DELETE".equalsIgnoreCase(string)) {
            if ("GET".equalsIgnoreCase(string)) {
                getMethod = new GetMethod();
            } else if ("DELETE".equalsIgnoreCase(string)) {
                getMethod = new DeleteMethod();
            }
            getMethod.getParams().setDefaults(httpParams);
            if (bl) {
                string5 = string6;
            }
            getMethod.setFollowRedirects(true);
        } else if ("POST".equalsIgnoreCase(string) || "PUT".equalsIgnoreCase(string)) {
            Part part;
            StringRequestEntity stringRequestEntity;
            if ("POST".equalsIgnoreCase(string)) {
                getMethod = new PostMethod();
            } else if ("PUT".equalsIgnoreCase(string)) {
                getMethod = new PutMethod();
            }
            getMethod.getParams().setDefaults(httpParams);
            String string8 = getMethod.getParams().getContentCharset();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Content-Type [" + string3 + "] Charset [" + string8 + "]"));
            }
            if (bl) {
                stringRequestEntity = new StringRequestEntity(string6, "application/x-www-form-urlencoded", string8);
            } else {
                part = bindingOperation.getOperation().getInput().getMessage().getPart(mIMEContent.getPart());
                Element element = map.get(part.getName());
                if (part.getElementName() == null) {
                    String string9 = "XML Types are not supported. Parts must use elements.";
                    if (log.isErrorEnabled()) {
                        log.error((Object)string9);
                    }
                    throw new RuntimeException(string9);
                }
                if (HttpUtils.isXml((String)string3)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Content-Type [" + string3 + "] equivalent to 'text/xml'"));
                    }
                    String string10 = DOMUtils.domToString((Node)DOMUtils.getFirstChildElement((Element)element));
                    stringRequestEntity = new StringRequestEntity(string10, string3, string8);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Content-Type [" + string3 + "] NOT equivalent to 'text/xml'. The text content of part value will be sent as text"));
                    }
                    stringRequestEntity = new StringRequestEntity(DOMUtils.getTextContent((Node)element), string3, string8);
                }
            }
            part = (EntityEnclosingMethod)getMethod;
            part.setRequestEntity((RequestEntity)stringRequestEntity);
            part.setContentChunked(httpParams.getBooleanParameter("http.request.chunk", false));
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + string);
        }
        getMethod.setPath(string7);
        getMethod.setQueryString(string5);
        this.setHttpRequestHeaders((HttpMethod)getMethod, bindingOperation, map, map2, httpParams);
        return getMethod;
    }

    public void setHttpRequestHeaders(HttpMethod httpMethod, BindingOperation bindingOperation, Map<String, Element> map, Map<String, Node> map2, HttpParams httpParams) {
        String string;
        Object object;
        Object object2;
        Object object4;
        BindingInput bindingInput = bindingOperation.getBindingInput();
        Message message = bindingOperation.getOperation().getInput().getMessage();
        Collection collection = (Collection)httpParams.getParameter("http.default-headers");
        if (collection != null) {
            object4 = collection.iterator();
            while (object4.hasNext()) {
                httpMethod.setRequestHeader((Header)object4.next());
            }
        }
        for (Map.Entry object32 : map2.entrySet()) {
            object2 = (String)object32.getKey();
            object = (Node)object32.getValue();
            string = DOMUtils.domToString((Node)object);
            httpMethod.setRequestHeader((String)object2, HttpHelper.replaceCRLFwithLWS(string));
        }
        object4 = WsdlUtils.getHttpHeaders((List)bindingInput.getExtensibilityElements());
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            String string2;
            Object object3;
            object2 = ((UnknownExtensibilityElement)iterator.next()).getElement();
            object = object2.getAttribute("name");
            string = object2.getAttribute("part");
            String string3 = object2.getAttribute("value");
            if (StringUtils.isNotEmpty((String)string)) {
                object3 = message.getPart(string);
                Element element = map.get(object3.getName());
                if (DOMUtils.isEmptyElement((Element)element)) {
                    string2 = "";
                } else {
                    Element element2 = DOMUtils.getFirstChildElement((Element)element);
                    if (element2 != null) {
                        if (DOMUtils.getFirstChildElement((Element)element2) != null) {
                            String string4 = "Complex types are not supported. Header Parts must be simple types or elements of a simple type.";
                            if (log.isErrorEnabled()) {
                                log.error((Object)string4);
                            }
                            throw new RuntimeException(string4);
                        }
                        string2 = DOMUtils.getTextContent((Node)element2);
                    } else {
                        string2 = DOMUtils.getTextContent((Node)element);
                    }
                }
            } else if (StringUtils.isNotEmpty((String)string3)) {
                string2 = string3;
            } else {
                object3 = "Invalid binding: missing attribute! Expecting " + new QName("http://www.apache.org/ode/type/extension/http", "part") + " or " + new QName("http://www.apache.org/ode/type/extension/http", "value");
                if (log.isErrorEnabled()) {
                    log.error(object3);
                }
                throw new RuntimeException((String)object3);
            }
            if (!StringUtils.isNotEmpty((String)string2)) continue;
            httpMethod.setRequestHeader((String)object, HttpHelper.replaceCRLFwithLWS(string2));
        }
        MIMEContent mIMEContent = WsdlUtils.getMimeContent((List)bindingOperation.getBindingOutput().getExtensibilityElements());
        if (mIMEContent != null) {
            httpMethod.setRequestHeader("Accept", mIMEContent.getType());
        }
    }

    protected Map<String, Element> extractPartElements(Message message, Element element) {
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        for (Part part : message.getParts().values()) {
            Element element2 = DOMUtils.findChildByName((Element)element, (QName)new QName(null, part.getName()));
            if (element2 == null) {
                throw new IllegalArgumentException(msgs.msgOdeMessageMissingRequiredPart(part.getName()));
            }
            hashMap.put(part.getName(), element2);
        }
        return hashMap;
    }

    public Element createPartElement(Part part, String string) {
        Document document = DOMUtils.newDocument();
        Element element = document.createElementNS(null, part.getName());
        if (part.getElementName() != null) {
            Element element2 = document.createElementNS(part.getElementName().getNamespaceURI(), part.getElementName().getLocalPart());
            element2.setTextContent(string);
            element.appendChild(element2);
        } else {
            element.setTextContent(string);
        }
        return element;
    }

    public Element createPartElement(Part part, Element element) {
        Document document = DOMUtils.newDocument();
        Element element2 = document.createElementNS(null, part.getName());
        if (part.getElementName() != null) {
            element2.appendChild(document.importNode(element, true));
        } else if (DOMUtils.isEmptyElement((Element)element)) {
            element2.appendChild(document.createTextNode(""));
        } else {
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                element2.appendChild(document.importNode(node, true));
            }
        }
        return element2;
    }

    public void extractHttpResponseHeaders(org.apache.ode.bpel.iapi.Message message, HttpMethod httpMethod, Operation operation) {
        Object object;
        Message message2 = operation.getOutput().getMessage();
        BindingOutput bindingOutput = this.binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName()).getBindingOutput();
        Collection collection = WsdlUtils.getHttpHeaders((List)bindingOutput.getExtensibilityElements());
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            Object object3;
            object = ((UnknownExtensibilityElement)object2.next()).getElement();
            String string = object.getAttribute("part");
            String string2 = object.getAttribute("name");
            Part part = message2.getPart(string);
            if (StringUtils.isNotEmpty((String)string)) {
                object3 = httpMethod.getResponseHeader(string2);
                if (object3 == null) continue;
                message.setPart(string, this.createPartElement(part, object3.getValue()));
                continue;
            }
            object3 = "Invalid binding: missing required attribute! Part name: " + new QName("http://www.apache.org/ode/type/extension/http", "part");
            if (log.isErrorEnabled()) {
                log.error(object3);
            }
            throw new RuntimeException((String)object3);
        }
        object2 = new HashSet();
        for (Header header : httpMethod.getResponseHeaders()) {
            object2.add(header.getName());
        }
        object = object2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            message.setHeaderPart(string, httpMethod.getResponseHeader(string).getValue());
        }
        message.setHeaderPart("Status-Line", HttpHelper.statusLineToElement(httpMethod.getStatusLine()));
    }

    public void parseHttpResponse(org.apache.ode.bpel.iapi.Message message, HttpMethod httpMethod, Operation operation) throws Exception {
        String string;
        BindingOperation bindingOperation = this.binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName());
        this.extractHttpResponseHeaders(message, httpMethod, operation);
        MIMEContent mIMEContent = WsdlUtils.getMimeContent((List)bindingOperation.getBindingOutput().getExtensibilityElements());
        int n = httpMethod.getStatusCode();
        boolean bl = mIMEContent != null && HttpUtils.isXml((String)mIMEContent.getType());
        boolean bl2 = mIMEContent != null;
        boolean bl3 = bl2 && HttpUtils.bodyAllowed((int)n) && n != 202;
        try {
            string = httpMethod.getResponseBodyAsString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to get the request body : " + iOException.getMessage());
        }
        boolean bl4 = StringUtils.isEmpty((String)string);
        if (bl4) {
            if (bl3) {
                throw new RuntimeException("Response body is mandatory but missing!");
            }
        } else if (bl2) {
            Element element;
            Part part = operation.getOutput().getMessage().getPart(mIMEContent.getPart());
            if (bl) {
                boolean bl5;
                Header header = httpMethod.getResponseHeader("Content-Type");
                String string2 = header != null ? header.getValue() : null;
                boolean bl6 = string2 != null;
                boolean bl7 = bl5 = bl6 && HttpUtils.isXml((String)string2);
                if (!bl6) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Received Response with a body but no 'Content-Type' header!");
                    }
                } else if (!bl5 && log.isDebugEnabled()) {
                    log.debug((Object)("Xml type was expected but non-xml type received! Expected Content-Type=" + mIMEContent.getType() + " Received Content-Type=" + string2));
                }
                Element element2 = DOMUtils.stringToDOM((String)string);
                element = this.createPartElement(part, element2);
            } else {
                element = this.createPartElement(part, string);
            }
            message.setPart(part.getName(), element);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Body received but not mapped to any part! Body=\n" + string));
        }
    }

    public Object[] parseFault(PartnerRoleMessageExchange partnerRoleMessageExchange, HttpMethod httpMethod) {
        Element element;
        String string;
        String string2;
        Operation operation = partnerRoleMessageExchange.getOperation();
        BindingOperation bindingOperation = this.binding.getBindingOperation(operation.getName(), operation.getInput().getName(), operation.getOutput().getName());
        try {
            string2 = httpMethod.getResponseBodyAsString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to get the request body : " + iOException.getMessage(), iOException);
        }
        Header header = httpMethod.getResponseHeader("Content-Type");
        String string3 = string = header != null ? header.getValue() : null;
        if (operation.getFaults().isEmpty()) {
            throw new RuntimeException("Operation [" + operation.getName() + "] has no fault. This " + httpMethod.getStatusCode() + " error will be considered as a failure.");
        }
        if (bindingOperation.getBindingFaults().isEmpty()) {
            throw new RuntimeException("No fault binding. This " + httpMethod.getStatusCode() + " error will be considered as a failure.");
        }
        if (StringUtils.isEmpty((String)string2)) {
            throw new RuntimeException("No body in the response. This " + httpMethod.getStatusCode() + " error will be considered as a failure.");
        }
        if (string != null && !HttpUtils.isXml((String)string)) {
            throw new RuntimeException("Response Content-Type [" + string + "] does not describe XML entities. Faults must be XML. This " + httpMethod.getStatusCode() + " error will be considered as a failure.");
        }
        if (string == null && log.isWarnEnabled()) {
            log.warn((Object)("[Service: " + this.serviceName + ", Port: " + this.portName + ", Operation: " + operation.getName() + "] Received Response with a body but no 'Content-Type' header! Will try to parse nevertheless."));
        }
        try {
            element = DOMUtils.stringToDOM((String)string2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse the response body as xml. This " + httpMethod.getStatusCode() + " error will be considered as a failure.", exception);
        }
        QName qName = new QName(element.getNamespaceURI(), element.getNodeName());
        Fault fault = WsdlUtils.inferFault((Operation)operation, (QName)qName);
        if (fault == null) {
            throw new RuntimeException("Unknown Fault Type [" + qName + "] This " + httpMethod.getStatusCode() + " error will be considered as a failure.");
        }
        if (!WsdlUtils.isOdeFault((BindingFault)bindingOperation.getBindingFault(fault.getName()))) {
            throw new RuntimeException("Fault [" + qName + "] is not bound with " + new QName("http://www.apache.org/ode/type/extension/http", "fault") + ". This " + httpMethod.getStatusCode() + " error will be considered as a failure.");
        }
        Part part = (Part)fault.getMessage().getParts().values().iterator().next();
        QName qName2 = new QName(this.definition.getTargetNamespace(), fault.getName());
        QName qName3 = fault.getMessage().getQName();
        org.apache.ode.bpel.iapi.Message message = partnerRoleMessageExchange.createMessage(qName3);
        Element element2 = this.createPartElement(part, element);
        message.setPart(part.getName(), element2);
        this.extractHttpResponseHeaders(message, httpMethod, operation);
        return new Object[]{qName2, message};
    }
}

