/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.soapbinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.wsdl.Messages;
import org.apache.ode.utils.wsdl.WsdlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapMessageConverter {
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private static final Log __log = LogFactory.getLog(SoapMessageConverter.class);
    SOAPFactory _soapFactory;
    Definition _def;
    QName _serviceName;
    String _portName;
    Service _serviceDef;
    Binding _binding;
    Port _port;
    boolean _isRPC;
    private SOAPBinding _soapBinding;

    public SoapMessageConverter(Definition definition, QName qName, String string) throws AxisFault {
        if (definition == null) {
            throw new NullPointerException("No WSDL definition was found for service " + qName + " and port " + string);
        }
        this._def = definition;
        this._serviceName = qName;
        this._portName = string;
        this._serviceDef = this._def.getService(qName);
        if (this._serviceDef == null) {
            throw new OdeFault(__msgs.msgServiceDefinitionNotFound(qName));
        }
        this._port = this._serviceDef.getPort(string);
        if (this._port == null) {
            throw new OdeFault(__msgs.msgPortDefinitionNotFound(qName, string));
        }
        this._binding = this._port.getBinding();
        if (this._binding == null) {
            throw new OdeFault(__msgs.msgBindingNotFound(string));
        }
        try {
            if (!WsdlUtils.useSOAPBinding((Port)this._port)) {
                throw new OdeFault(__msgs.msgNoSOAPBindingForPort(this._portName));
            }
            this._soapBinding = (SOAPBinding)WsdlUtils.getBindingExtension((Port)this._port);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OdeFault(illegalArgumentException);
        }
        String string2 = this._soapBinding.getStyle();
        boolean bl = this._isRPC = string2 != null && string2.equals("rpc");
        if (this._soapBinding.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) {
            this._soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (this._soapBinding.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) {
            this._soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            throw new IllegalStateException("Unsupported SOAP binding: " + this._soapBinding.getElementType());
        }
    }

    public void createSoapRequest(MessageContext messageContext, org.apache.ode.bpel.iapi.Message message, Operation operation) throws AxisFault {
        if (operation == null) {
            throw new NullPointerException("Null operation");
        }
        if (operation.getInput().getMessage().getParts().size() > 0 && message == null) {
            throw new NullPointerException("Null message.");
        }
        if (messageContext == null) {
            throw new NullPointerException("Null msgCtx");
        }
        BindingOperation bindingOperation = this._binding.getBindingOperation(operation.getName(), null, null);
        if (bindingOperation == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, operation.getName()));
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput == null) {
            throw new OdeFault(__msgs.msgBindingInputNotFound(this._serviceName, this._portName, operation.getName()));
        }
        SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
        if (sOAPEnvelope == null) {
            sOAPEnvelope = this._soapFactory.getDefaultEnvelope();
            messageContext.setEnvelope(sOAPEnvelope);
        }
        this.createSoapHeaders(sOAPEnvelope, SoapMessageConverter.getSOAPHeaders((ElementExtensible)bindingInput), operation.getInput().getMessage(), message.getHeaderParts());
        SOAPBody sOAPBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bindingInput);
        if (sOAPBody != null) {
            org.apache.axiom.soap.SOAPBody sOAPBody2 = sOAPEnvelope.getBody() == null ? this._soapFactory.createSOAPBody(sOAPEnvelope) : sOAPEnvelope.getBody();
            this.createSoapBody(sOAPBody2, sOAPBody, operation.getInput().getMessage(), message.getMessage(), operation.getName());
        }
    }

    public void createSoapResponse(MessageContext messageContext, org.apache.ode.bpel.iapi.Message message, Operation operation) throws AxisFault {
        SOAPBody sOAPBody;
        if (operation == null) {
            throw new NullPointerException("Null operation");
        }
        if (message == null) {
            throw new NullPointerException("Null message.");
        }
        if (messageContext == null) {
            throw new NullPointerException("Null msgCtx");
        }
        BindingOperation bindingOperation = this._binding.getBindingOperation(operation.getName(), null, null);
        if (bindingOperation == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, operation.getName()));
        }
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput == null) {
            throw new OdeFault(__msgs.msgBindingOutputNotFound(this._serviceName, this._portName, operation.getName()));
        }
        SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
        if (sOAPEnvelope == null) {
            sOAPEnvelope = this._soapFactory.getDefaultEnvelope();
            messageContext.setEnvelope(sOAPEnvelope);
        }
        if (message.getHeaderParts().size() > 0 || SoapMessageConverter.getSOAPHeaders((ElementExtensible)bindingOutput).size() > 0) {
            this.createSoapHeaders(sOAPEnvelope, SoapMessageConverter.getSOAPHeaders((ElementExtensible)bindingOutput), operation.getOutput().getMessage(), message.getHeaderParts());
        }
        if ((sOAPBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bindingOutput)) != null) {
            org.apache.axiom.soap.SOAPBody sOAPBody2 = sOAPEnvelope.getBody() == null ? this._soapFactory.createSOAPBody(sOAPEnvelope) : sOAPEnvelope.getBody();
            this.createSoapBody(sOAPBody2, sOAPBody, operation.getOutput().getMessage(), message.getMessage(), operation.getName() + "Response");
        }
    }

    public void createSoapHeaders(SOAPEnvelope sOAPEnvelope, List<javax.wsdl.extensions.soap.SOAPHeader> list, Message message, Map<String, Node> map) throws AxisFault {
        for (javax.wsdl.extensions.soap.SOAPHeader object : list) {
            this.handleSoapHeaderDef(sOAPEnvelope, object, message, map);
        }
        SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
        if (sOAPHeader == null) {
            sOAPHeader = this._soapFactory.createSOAPHeader(sOAPEnvelope);
        }
        for (Node node : map.values()) {
            if (node.getNodeType() == 1) {
                if (sOAPHeader.getFirstChildWithName(new QName(node.getNamespaceURI(), node.getLocalName())) != null) continue;
                OMElement oMElement = OMUtils.toOM((Element)((Element)node), (OMFactory)this._soapFactory);
                SOAPHeaderBlock sOAPHeaderBlock = sOAPHeader.addHeaderBlock(oMElement.getLocalName(), oMElement.getNamespace());
                OMNode oMNode = null;
                Iterator iterator = oMElement.getChildren();
                while (iterator.hasNext()) {
                    oMNode = (OMNode)iterator.next();
                    sOAPHeaderBlock.addChild(oMNode);
                }
                iterator = null;
                Iterator iterator2 = oMElement.getAllAttributes();
                while (iterator2.hasNext()) {
                    iterator = (OMAttribute)iterator2.next();
                    sOAPHeaderBlock.addAttribute((OMAttribute)iterator);
                }
                continue;
            }
            throw new OdeFault(__msgs.msgSoapHeaderMustBeAnElement(node));
        }
    }

    private void handleSoapHeaderDef(SOAPEnvelope sOAPEnvelope, javax.wsdl.extensions.soap.SOAPHeader sOAPHeader, Message message, Map<String, Node> map) throws AxisFault {
        boolean bl;
        boolean bl2 = bl = sOAPHeader.getMessage() == null || sOAPHeader.getMessage().equals(message.getQName());
        if (sOAPHeader.getPart() == null) {
            return;
        }
        if (bl && message.getPart(sOAPHeader.getPart()) == null) {
            throw new OdeFault(__msgs.msgSoapHeaderReferencesUnkownPart(sOAPHeader.getPart()));
        }
        Element element = null;
        if (map.size() > 0 && bl) {
            try {
                element = (Element)map.get(sOAPHeader.getPart());
            }
            catch (ClassCastException classCastException) {
                throw new OdeFault(__msgs.msgSoapHeaderMustBeAnElement(map.get(sOAPHeader.getPart())));
            }
        }
        if (element == null && bl) {
            throw new OdeFault(__msgs.msgOdeMessageMissingRequiredPart(sOAPHeader.getPart()));
        }
        if (element == null) {
            return;
        }
        SOAPHeader sOAPHeader2 = sOAPEnvelope.getHeader();
        if (sOAPHeader2 == null) {
            sOAPHeader2 = this._soapFactory.createSOAPHeader(sOAPEnvelope);
        }
        OMElement oMElement = OMUtils.toOM((Element)element, (OMFactory)this._soapFactory);
        Iterator iterator = oMElement.getChildren();
        while (iterator.hasNext()) {
            sOAPHeader2.addChild((OMNode)iterator.next());
        }
    }

    public SOAPFault createSoapFault(Element element, QName qName, Operation operation) throws AxisFault {
        OMElement oMElement = this.buildSoapDetail(element, qName, operation);
        SOAPFault sOAPFault = this._soapFactory.createSOAPFault();
        SOAPFaultCode sOAPFaultCode = this._soapFactory.createSOAPFaultCode(sOAPFault);
        sOAPFaultCode.setText(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"));
        SOAPFaultReason sOAPFaultReason = this._soapFactory.createSOAPFaultReason(sOAPFault);
        sOAPFaultReason.setText(qName);
        SOAPFaultDetail sOAPFaultDetail = this._soapFactory.createSOAPFaultDetail(sOAPFault);
        if (oMElement != null) {
            sOAPFaultDetail.addDetailEntry(oMElement);
        }
        return sOAPFault;
    }

    private OMElement buildSoapDetail(Element element, QName qName, Operation operation) throws AxisFault {
        if (qName.getNamespaceURI() == null) {
            return this.toFaultDetail(qName, element);
        }
        Fault fault = operation.getFault(qName.getLocalPart());
        if (fault == null) {
            return this.toFaultDetail(qName, element);
        }
        Part part = (Part)fault.getMessage().getParts().values().iterator().next();
        if (part == null) {
            return this.toFaultDetail(qName, element);
        }
        Element element2 = DOMUtils.findChildByName((Element)element, (QName)new QName(null, part.getName()));
        if (element2 == null) {
            return this.toFaultDetail(qName, element);
        }
        Element element3 = DOMUtils.findChildByName((Element)element2, (QName)part.getElementName());
        if (element3 == null) {
            return this.toFaultDetail(qName, element);
        }
        return OMUtils.toOM((Element)element3, (OMFactory)this._soapFactory);
    }

    private OMElement toFaultDetail(QName qName, Element element) {
        if (element == null) {
            return null;
        }
        Element element2 = DOMUtils.getFirstChildElement((Element)element);
        if (element2 == null) {
            return null;
        }
        Element element3 = DOMUtils.getFirstChildElement((Element)element2);
        if (element3 == null) {
            return OMUtils.toOM((Element)element2, (OMFactory)this._soapFactory);
        }
        return OMUtils.toOM((Element)element3, (OMFactory)this._soapFactory);
    }

    public void parseSoapRequest(org.apache.ode.bpel.iapi.Message message, SOAPEnvelope sOAPEnvelope, Operation operation) throws AxisFault {
        BindingOperation bindingOperation = this._binding.getBindingOperation(operation.getName(), null, null);
        if (bindingOperation == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, operation.getName()));
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput == null) {
            throw new OdeFault(__msgs.msgBindingInputNotFound(this._serviceName, this._portName, operation.getName()));
        }
        SOAPBody sOAPBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bindingInput);
        if (sOAPBody != null) {
            this.extractSoapBodyParts(message, sOAPEnvelope.getBody(), sOAPBody, operation.getInput().getMessage(), operation.getName());
        }
        if (sOAPEnvelope.getHeader() != null) {
            this.extractSoapHeaderParts(message, sOAPEnvelope.getHeader(), SoapMessageConverter.getSOAPHeaders((ElementExtensible)bindingInput), operation.getInput().getMessage());
        }
    }

    public void parseSoapResponse(org.apache.ode.bpel.iapi.Message message, SOAPEnvelope sOAPEnvelope, Operation operation) throws AxisFault {
        BindingOperation bindingOperation = this._binding.getBindingOperation(operation.getName(), null, null);
        if (bindingOperation == null) {
            throw new OdeFault(__msgs.msgBindingOperationNotFound(this._serviceName, this._portName, operation.getName()));
        }
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        if (bindingOutput == null) {
            throw new OdeFault(__msgs.msgBindingInputNotFound(this._serviceName, this._portName, operation.getName()));
        }
        SOAPBody sOAPBody = SoapMessageConverter.getSOAPBody((ElementExtensible)bindingOutput);
        if (sOAPBody != null) {
            this.extractSoapBodyParts(message, sOAPEnvelope.getBody(), sOAPBody, operation.getOutput().getMessage(), operation.getName() + "Response");
        }
        if (sOAPEnvelope.getHeader() != null) {
            this.extractSoapHeaderParts(message, sOAPEnvelope.getHeader(), SoapMessageConverter.getSOAPHeaders((ElementExtensible)bindingOutput), operation.getOutput().getMessage());
        }
    }

    public void createSoapBody(org.apache.axiom.soap.SOAPBody sOAPBody, SOAPBody sOAPBody2, Message message, Element element, String string) throws AxisFault {
        org.apache.axiom.soap.SOAPBody sOAPBody3 = this._isRPC ? this._soapFactory.createOMElement(new QName(sOAPBody2.getNamespaceURI(), string, "odens"), (OMContainer)sOAPBody) : sOAPBody;
        List list = message.getOrderedParts(sOAPBody2.getParts());
        for (Part part : list) {
            Element element2 = DOMUtils.findChildByName((Element)element, (QName)new QName(null, part.getName()));
            if (element2 == null) {
                throw new OdeFault(__msgs.msgOdeMessageMissingRequiredPart(part.getName()));
            }
            OMElement oMElement = OMUtils.toOM((Element)element2, (OMFactory)this._soapFactory);
            if (this._isRPC) {
                sOAPBody3.addChild((OMNode)oMElement);
                continue;
            }
            Iterator iterator = oMElement.getChildren();
            while (iterator.hasNext()) {
                sOAPBody3.addChild((OMNode)iterator.next());
            }
        }
    }

    public void extractSoapBodyParts(org.apache.ode.bpel.iapi.Message message, org.apache.axiom.soap.SOAPBody sOAPBody, SOAPBody sOAPBody2, Message message2, String string) throws AxisFault {
        List list = message2.getOrderedParts(sOAPBody2.getParts());
        if (this._isRPC) {
            QName qName = new QName(sOAPBody2.getNamespaceURI(), string);
            OMElement oMElement = sOAPBody.getFirstChildWithName(qName);
            if (oMElement == null) {
                throw new OdeFault(__msgs.msgSoapBodyDoesNotContainExpectedPartWrapper(this._serviceName, this._portName, qName));
            }
            for (Part part : list) {
                OMElement oMElement2 = oMElement.getFirstChildWithName(new QName(null, part.getName()));
                if (oMElement2 == null) {
                    throw new OdeFault(__msgs.msgSOAPBodyDoesNotContainRequiredPart(part.getName()));
                }
                message.setPart(oMElement2.getLocalName(), OMUtils.toDOM((OMElement)oMElement2));
            }
        } else {
            Iterator iterator = sOAPBody.getChildElements();
            for (Part part : list) {
                if (!iterator.hasNext()) {
                    throw new OdeFault(__msgs.msgSOAPBodyDoesNotContainRequiredPart(part.getName()));
                }
                OMElement oMElement = (OMElement)iterator.next();
                if (part.getElementName() == null) {
                    throw new OdeFault(__msgs.msgBindingDefinesNonElementDocListParts());
                }
                if (!oMElement.getQName().equals(part.getElementName())) {
                    throw new OdeFault(__msgs.msgUnexpectedElementInSOAPBody(oMElement.getQName(), part.getElementName()));
                }
                Document document = DOMUtils.newDocument();
                Element element = document.createElementNS(null, part.getName());
                element.appendChild(document.importNode(OMUtils.toDOM((OMElement)oMElement), true));
                message.setPart(part.getName(), element);
            }
        }
    }

    public void extractSoapHeaderParts(org.apache.ode.bpel.iapi.Message message, SOAPHeader sOAPHeader, List<javax.wsdl.extensions.soap.SOAPHeader> list, Message message2) throws AxisFault {
        for (javax.wsdl.extensions.soap.SOAPHeader sOAPHeader2 : list) {
            this.handleSoapHeaderPartDef(message, sOAPHeader, sOAPHeader2, message2);
        }
        Iterator iterator = sOAPHeader.getChildElements();
        while (iterator.hasNext()) {
            javax.wsdl.extensions.soap.SOAPHeader sOAPHeader2;
            sOAPHeader2 = (OMElement)iterator.next();
            String string = this.findHeaderPartName(list, sOAPHeader2.getQName());
            message.setHeaderPart(string, OMUtils.toDOM((OMElement)sOAPHeader2));
        }
    }

    private void handleSoapHeaderPartDef(org.apache.ode.bpel.iapi.Message message, SOAPHeader sOAPHeader, javax.wsdl.extensions.soap.SOAPHeader sOAPHeader2, Message message2) throws AxisFault {
        boolean bl;
        boolean bl2 = sOAPHeader2.getMessage() == null || sOAPHeader2.getMessage().equals(message2.getQName());
        boolean bl3 = bl = bl2 || sOAPHeader2.getRequired() != null && sOAPHeader2.getRequired() != false;
        if (bl && sOAPHeader == null) {
            throw new OdeFault(__msgs.msgSoapHeaderMissingRequiredElement(sOAPHeader2.getElementType()));
        }
        if (sOAPHeader == null) {
            return;
        }
        Message message3 = this._def.getMessage(sOAPHeader2.getMessage());
        if (message3 == null) {
            return;
        }
        Part part = message3.getPart(sOAPHeader2.getPart());
        if (part == null || part.getElementName() == null) {
            return;
        }
        OMElement oMElement = sOAPHeader.getFirstChildWithName(part.getElementName());
        if (bl && oMElement == null) {
            throw new OdeFault(__msgs.msgSoapHeaderMissingRequiredElement(sOAPHeader2.getElementType()));
        }
        if (oMElement == null) {
            return;
        }
        message.setHeaderPart(part.getName(), OMUtils.toDOM((OMElement)oMElement));
    }

    private String findHeaderPartName(List<javax.wsdl.extensions.soap.SOAPHeader> list, QName qName) {
        for (javax.wsdl.extensions.soap.SOAPHeader sOAPHeader : list) {
            Message message = this._def.getMessage(sOAPHeader.getMessage());
            for (Object v : message.getParts().values()) {
                Part part = (Part)v;
                if (!part.getElementName().equals(qName)) continue;
                return part.getName();
            }
        }
        return qName.getLocalPart();
    }

    public static SOAPBody getSOAPBody(ElementExtensible elementExtensible) {
        return SoapMessageConverter.getFirstExtensibilityElement(elementExtensible, SOAPBody.class);
    }

    public static List<javax.wsdl.extensions.soap.SOAPHeader> getSOAPHeaders(ElementExtensible elementExtensible) {
        return (List)CollectionsX.filter(new ArrayList(), (Collection)elementExtensible.getExtensibilityElements(), javax.wsdl.extensions.soap.SOAPHeader.class);
    }

    public static <T> T getFirstExtensibilityElement(ElementExtensible elementExtensible, Class<T> clazz) {
        Collection collection = CollectionsX.filter((Collection)elementExtensible.getExtensibilityElements(), clazz);
        return collection.isEmpty() ? null : (T)collection.iterator().next();
    }

    public String getWSAInputAction(String string) {
        Object object;
        BindingOperation bindingOperation = this._binding.getBindingOperation(string, null, null);
        if (bindingOperation == null) {
            return "";
        }
        Input input = bindingOperation.getOperation().getInput();
        if (input != null && (object = input.getExtensionAttribute(new QName("http://www.w3.org/2005/08/addressing", "Action"))) != null && object instanceof QName) {
            return ((QName)object).getLocalPart();
        }
        return "";
    }

    public String getSoapAction(String string) {
        BindingOperation bindingOperation = this._binding.getBindingOperation(string, null, null);
        if (bindingOperation == null) {
            return "";
        }
        Iterator iterator = CollectionsX.filter((Collection)bindingOperation.getExtensibilityElements(), SOAPOperation.class).iterator();
        if (iterator.hasNext()) {
            SOAPOperation sOAPOperation = (SOAPOperation)iterator.next();
            return sOAPOperation.getSoapActionURI();
        }
        return "";
    }

    public Fault parseSoapFault(Element element, SOAPEnvelope sOAPEnvelope, Operation operation) throws AxisFault {
        SOAPFault sOAPFault = sOAPEnvelope.getBody().getFault();
        SOAPFaultDetail sOAPFaultDetail = sOAPFault.getDetail();
        Fault fault = this.inferFault(operation, sOAPFault);
        if (fault == null) {
            return null;
        }
        Part part = (Part)fault.getMessage().getParts().values().iterator().next();
        Element element2 = element.getOwnerDocument().createElementNS(null, part.getName());
        element.appendChild(element2);
        if (sOAPFaultDetail.getFirstChildWithName(part.getElementName()) != null) {
            element2.appendChild(element.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)sOAPFaultDetail.getFirstChildWithName(part.getElementName())), true));
        } else {
            element2.appendChild(element.getOwnerDocument().importNode(OMUtils.toDOM((OMElement)sOAPFaultDetail), true));
        }
        return fault;
    }

    private Fault inferFault(Operation operation, SOAPFault sOAPFault) {
        if (sOAPFault.getDetail() == null) {
            return null;
        }
        QName qName = sOAPFault.getDetail().getFirstElement().getQName();
        return WsdlUtils.inferFault((Operation)operation, (QName)qName);
    }
}

