/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LeaderElection
implements Election {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderElection.class);
    protected static final Random epochGen = new Random();
    protected QuorumPeer self;

    public LeaderElection(QuorumPeer self) {
        this.self = self;
    }

    protected ElectionResult countVotes(HashMap<InetSocketAddress, Vote> votes, HashSet<Long> heardFrom) {
        Vote v;
        ElectionResult result = new ElectionResult();
        result.vote = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        result.winner = new Vote(Long.MIN_VALUE, Long.MIN_VALUE);
        HashMap<InetSocketAddress, Vote> validVotes = new HashMap<InetSocketAddress, Vote>();
        HashMap<Long, Long> maxZxids = new HashMap<Long, Long>();
        for (Map.Entry<InetSocketAddress, Vote> entry : votes.entrySet()) {
            v = entry.getValue();
            if (!heardFrom.contains(v.getId())) continue;
            validVotes.put(entry.getKey(), v);
            Long val = (Long)maxZxids.get(v.getId());
            if (val != null && val >= v.getZxid()) continue;
            maxZxids.put(v.getId(), v.getZxid());
        }
        for (Map.Entry entry : validVotes.entrySet()) {
            v = (Vote)entry.getValue();
            Long zxid = (Long)maxZxids.get(v.getId());
            if (v.getZxid() >= zxid) continue;
            entry.setValue(new Vote(v.getId(), zxid, v.getElectionEpoch(), v.getPeerEpoch(), v.getState()));
        }
        result.numValidVotes = validVotes.size();
        HashMap<Vote, Integer> hashMap = new HashMap<Vote, Integer>();
        for (Vote vote : validVotes.values()) {
            Integer count = (Integer)hashMap.get(vote);
            if (count == null) {
                count = 0;
            }
            hashMap.put(vote, count + 1);
            if (vote.getId() == result.vote.getId()) {
                ++result.count;
                continue;
            }
            if (vote.getZxid() <= result.vote.getZxid() && (vote.getZxid() != result.vote.getZxid() || vote.getId() <= result.vote.getId())) continue;
            result.vote = vote;
            result.count = 1;
        }
        result.winningCount = 0;
        LOG.info("Election tally: ");
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() > result.winningCount) {
                result.winningCount = (Integer)entry.getValue();
                result.winner = (Vote)entry.getKey();
            }
            LOG.info(String.valueOf(((Vote)entry.getKey()).getId()) + "\t-> " + entry.getValue());
        }
        return result;
    }

    @Override
    public void shutdown() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Vote lookForLeader() throws InterruptedException {
        try {
            this.self.jmxLeaderElectionBean = new LeaderElectionBean();
            MBeanRegistry.getInstance().register(this.self.jmxLeaderElectionBean, this.self.jmxLocalPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", (Throwable)e);
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
            byte[] requestBytes = new byte[4];
            ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
            byte[] responseBytes = new byte[28];
            ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
            DatagramSocket s = null;
            try {
                s = new DatagramSocket();
                s.setSoTimeout(200);
            }
            catch (SocketException e1) {
                LOG.error("Socket exception when creating socket for leader election", (Throwable)e1);
                System.exit(4);
            }
            DatagramPacket requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
            DatagramPacket responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
            int xid = epochGen.nextInt();
            while (this.self.isRunning()) {
                HashMap<InetSocketAddress, Vote> votes = new HashMap<InetSocketAddress, Vote>(this.self.getVotingView().size());
                requestBuffer.clear();
                requestBuffer.putInt(xid);
                requestPacket.setLength(4);
                HashSet<Long> heardFrom = new HashSet<Long>();
                for (QuorumPeer.QuorumServer server : this.self.getVotingView().values()) {
                    LOG.info("Server address: " + server.addr);
                    try {
                        requestPacket.setSocketAddress(server.addr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + server.addr, e);
                    }
                    try {
                        s.send(requestPacket);
                        responsePacket.setLength(responseBytes.length);
                        s.receive(responsePacket);
                        if (responsePacket.getLength() != responseBytes.length) {
                            LOG.error("Got a short response: " + responsePacket.getLength());
                            continue;
                        }
                        responseBuffer.clear();
                        int recvedXid = responseBuffer.getInt();
                        if (recvedXid != xid) {
                            LOG.error("Got bad xid: expected " + xid + " got " + recvedXid);
                            continue;
                        }
                        long peerId = responseBuffer.getLong();
                        heardFrom.add(peerId);
                        Vote vote = new Vote(responseBuffer.getLong(), responseBuffer.getLong());
                        InetSocketAddress addr = (InetSocketAddress)responsePacket.getSocketAddress();
                        votes.put(addr, vote);
                    }
                    catch (IOException e) {
                        LOG.warn("Ignoring exception while looking for leader", (Throwable)e);
                    }
                }
                ElectionResult result = this.countVotes(votes, heardFrom);
                if (result.numValidVotes == 0) {
                    this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
                } else if (result.winner.getId() >= 0L) {
                    this.self.setCurrentVote(result.vote);
                    if (result.winningCount > this.self.getVotingView().size() / 2) {
                        this.self.setCurrentVote(result.winner);
                        s.close();
                        Vote current = this.self.getCurrentVote();
                        LOG.info("Found leader: my type is: " + (Object)((Object)this.self.getLearnerType()));
                        if (this.self.getLearnerType() == QuorumPeer.LearnerType.OBSERVER) {
                            if (current.getId() != this.self.getId()) {
                                this.self.setPeerState(QuorumPeer.ServerState.OBSERVING);
                                Thread.sleep(100L);
                                Vote vote = current;
                                return vote;
                            }
                            LOG.error("OBSERVER elected as leader!");
                            Thread.sleep(100L);
                        } else {
                            this.self.setPeerState(current.getId() == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                            if (this.self.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                                Thread.sleep(100L);
                            }
                            Vote vote = current;
                            return vote;
                        }
                    }
                }
                Thread.sleep(1000L);
            }
            return null;
        }
        finally {
            try {
                if (this.self.jmxLeaderElectionBean != null) {
                    MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister with JMX", (Throwable)e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
    }

    protected static class ElectionResult {
        public Vote vote;
        public int count;
        public Vote winner;
        public int winningCount;
        public int numValidVotes;

        protected ElectionResult() {
        }
    }
}

