/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.DatabaseException;
import org.apache.ode.scheduler.simple.Job;
import org.apache.ode.scheduler.simple.SchedulerThread;
import org.apache.ode.scheduler.simple.Task;
import org.apache.ode.scheduler.simple.TaskRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScheduler
implements Scheduler,
TaskRunner {
    private static final Log __log = LogFactory.getLog(SimpleScheduler.class);
    long _immediateInterval = 30000L;
    long _nearFutureInterval = 600000L;
    long _staleInterval = 10000L;
    TransactionManager _txm;
    String _nodeId;
    int _todoLimit = 10000;
    volatile Scheduler.JobProcessor _jobProcessor;
    private SchedulerThread _todo;
    private DatabaseDelegate _db;
    private CopyOnWriteArraySet<String> _knownNodes = new CopyOnWriteArraySet();
    private ConcurrentHashMap<String, Long> _lastHeartBeat = new ConcurrentHashMap();
    private boolean _running;
    private AtomicLong _nextUpgrade = new AtomicLong();
    private AtomicLong _nextScheduleImmediate = new AtomicLong();
    private Random _random = new Random();

    public SimpleScheduler(String string, DatabaseDelegate databaseDelegate, Properties properties) {
        this._nodeId = string;
        this._db = databaseDelegate;
        this._todoLimit = Integer.parseInt(properties.getProperty("ode.scheduler.queueLength", "10000"));
        this._todo = new SchedulerThread(this);
    }

    public void setNodeId(String string) {
        this._nodeId = string;
    }

    public void setStaleInterval(long l) {
        this._staleInterval = l;
    }

    public void setImmediateInterval(long l) {
        this._immediateInterval = l;
    }

    public void setNearFutureInterval(long l) {
        this._nearFutureInterval = l;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this._txm = transactionManager;
    }

    public void setDatabaseDelegate(DatabaseDelegate databaseDelegate) {
        this._db = databaseDelegate;
    }

    public void cancelJob(String string) throws ContextException {
        this._todo.dequeue(new Job(0L, string, false, null));
        try {
            this._db.deleteJob(string, this._nodeId);
        }
        catch (DatabaseException databaseException) {
            __log.debug((Object)"Job removal failed.", (Throwable)databaseException);
            throw new ContextException("Job removal failed.", (Throwable)databaseException);
        }
    }

    public <T> T execTransaction(Callable<T> callable) throws Exception, ContextException {
        try {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Beginning a new transaction");
            }
            this._txm.begin();
        }
        catch (Exception exception) {
            String string = "Internal Error, could not begin transaction.";
            throw new ContextException(string, (Throwable)exception);
        }
        boolean bl = false;
        try {
            T t = callable.call();
            bl = true;
            T t2 = t;
            return t2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (bl) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)"Commiting...");
                }
                this._txm.commit();
            } else {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)"Rollbacking...");
                }
                this._txm.rollback();
            }
        }
    }

    public String schedulePersistedJob(Map<String, Object> map, Date date) throws ContextException {
        long l = System.currentTimeMillis();
        if (date == null) {
            date = new Date(l);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("scheduling " + map + " for " + date));
        }
        boolean bl = date.getTime() <= l + this._immediateInterval;
        boolean bl2 = !bl && date.getTime() <= l + this._nearFutureInterval;
        Job job = new Job(date.getTime(), true, map);
        try {
            if (bl) {
                if (this._todo.size() > this._todoLimit) {
                    __log.error((Object)"The execution queue is backed up, the engine can't keep up with the load. Either increase the queue size or regulate the flow.");
                    return null;
                }
                this._db.insertJob(job, this._nodeId, true);
                this.addTodoOnCommit(job);
                __log.debug((Object)("scheduled immediate job: " + job.jobId));
            } else if (bl2) {
                this._db.insertJob(job, this._nodeId, false);
                __log.debug((Object)("scheduled near-future job: " + job.jobId));
            } else {
                this._db.insertJob(job, null, false);
                __log.debug((Object)("scheduled far-future job: " + job.jobId));
            }
        }
        catch (DatabaseException databaseException) {
            __log.error((Object)"Database error.", (Throwable)databaseException);
            throw new ContextException("Database error.", (Throwable)databaseException);
        }
        return job.jobId;
    }

    public String scheduleVolatileJob(boolean bl, Map<String, Object> map) throws ContextException {
        Job job = new Job(System.currentTimeMillis(), bl, map);
        job.persisted = false;
        this.addTodoOnCommit(job);
        return job.toString();
    }

    public void setJobProcessor(Scheduler.JobProcessor jobProcessor) throws ContextException {
        this._jobProcessor = jobProcessor;
    }

    public void shutdown() {
        this.stop();
        this._jobProcessor = null;
        this._txm = null;
        this._todo = null;
    }

    public synchronized void start() {
        if (this._running) {
            return;
        }
        this._todo.clearTasks(UpgradeJobsTask.class);
        this._todo.clearTasks(LoadImmediateTask.class);
        this._todo.clearTasks(CheckStaleNodes.class);
        this._knownNodes.clear();
        try {
            this.execTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    SimpleScheduler.this._knownNodes.addAll(SimpleScheduler.this._db.getNodeIds());
                    return null;
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)"Error retrieving node list.", (Throwable)exception);
            throw new ContextException("Error retrieving node list.", (Throwable)exception);
        }
        for (String string : this._knownNodes) {
            this._lastHeartBeat.put(string, System.currentTimeMillis());
        }
        this._todo.enqueue(new LoadImmediateTask(System.currentTimeMillis()));
        this._todo.enqueue(new CheckStaleNodes(System.currentTimeMillis() + (long)(this._random.nextDouble() * (double)this._staleInterval)));
        this._todo.enqueue(new UpgradeJobsTask(System.currentTimeMillis() + (long)(this._random.nextDouble() * (double)this._immediateInterval)));
        this._todo.start();
        this._running = true;
    }

    public synchronized void stop() {
        if (!this._running) {
            return;
        }
        this._todo.stop();
        this._todo.clearTasks(UpgradeJobsTask.class);
        this._todo.clearTasks(LoadImmediateTask.class);
        this._todo.clearTasks(CheckStaleNodes.class);
        this._running = false;
    }

    public void jobCompleted(String string) {
        boolean bl = false;
        try {
            bl = this._db.deleteJob(string, this._nodeId);
        }
        catch (DatabaseException databaseException) {
            String string2 = "Database error.";
            __log.error((Object)string2, (Throwable)databaseException);
            throw new ContextException(string2, (Throwable)databaseException);
        }
        if (!bl) {
            try {
                this._txm.getTransaction().setRollbackOnly();
            }
            catch (Exception exception) {
                __log.error((Object)"Transaction manager error; setRollbackOnly() failed.", (Throwable)exception);
            }
            throw new ContextException("Job no longer in database: jobId=" + string);
        }
    }

    protected void runJob(Job job) {
        block5: {
            Scheduler.JobInfo jobInfo = new Scheduler.JobInfo(job.jobId, job.detail, ((Integer)(job.detail.get("retry") != null ? job.detail.get("retry") : Integer.valueOf(0))).intValue());
            try {
                try {
                    this._jobProcessor.onScheduledJob(jobInfo);
                }
                catch (Scheduler.JobProcessorException jobProcessorException) {
                    if (jobProcessorException.retry) {
                        __log.error((Object)("Error while processing transaction, retrying in " + this.doRetry(job) + "s"));
                        break block5;
                    }
                    __log.error((Object)"Error while processing transaction, no retry.", (Throwable)jobProcessorException);
                }
            }
            catch (Exception exception) {
                __log.error((Object)"Error in scheduler processor.", (Throwable)exception);
            }
        }
    }

    private void addTodoOnCommit(final Job job) {
        Transaction transaction;
        try {
            transaction = this._txm.getTransaction();
        }
        catch (Exception exception) {
            String string = "Transaction manager error; unable to obtain transaction.";
            __log.error((Object)string, (Throwable)exception);
            throw new ContextException(string, (Throwable)exception);
        }
        if (transaction == null) {
            throw new ContextException("Missing required transaction in thread " + Thread.currentThread());
        }
        try {
            transaction.registerSynchronization(new Synchronization(){

                public void afterCompletion(int n) {
                    if (n == 3) {
                        SimpleScheduler.this._todo.enqueue(job);
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (Exception exception) {
            String string = "Unable to registrer synchronizer. ";
            __log.error((Object)string, (Throwable)exception);
            throw new ContextException(string, (Throwable)exception);
        }
    }

    @Override
    public void runTask(Task task) {
        if (task instanceof Job) {
            this.runJob((Job)task);
        }
        if (task instanceof SchedulerTask) {
            ((SchedulerTask)task).run();
        }
    }

    public void updateHeartBeat(String string) {
        if (string == null) {
            return;
        }
        if (this._nodeId.equals(string)) {
            return;
        }
        this._lastHeartBeat.put(string, System.currentTimeMillis());
        this._knownNodes.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doLoadImmediate() {
        __log.debug((Object)"LOAD IMMEDIATE started");
        try {
            List<Job> list;
            do {
                list = this.execTransaction(new Callable<List<Job>>(){

                    @Override
                    public List<Job> call() throws Exception {
                        return SimpleScheduler.this._db.dequeueImmediate(SimpleScheduler.this._nodeId, System.currentTimeMillis() + SimpleScheduler.this._immediateInterval, 10);
                    }
                });
                for (Job job : list) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("todo.enqueue job from db: " + job.jobId + " for " + job.schedDate));
                    }
                    this._todo.enqueue(job);
                }
            } while (list.size() == 10);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            __log.error((Object)"Error loading immediate jobs from database.", (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            __log.debug((Object)"LOAD IMMEDIATE complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doUpgrade() {
        __log.debug((Object)"UPGRADE started");
        final ArrayList<String> arrayList = new ArrayList<String>(this._knownNodes);
        arrayList.add(this._nodeId);
        Collections.sort(arrayList);
        final long l = System.currentTimeMillis() + this._nearFutureInterval;
        try {
            boolean bl = this.execTransaction(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        String string = (String)arrayList.get(i);
                        SimpleScheduler.this._db.updateAssignToNode(string, i, n, l);
                    }
                    return true;
                }
            });
            return bl;
        }
        catch (Exception exception) {
            __log.error((Object)"Database error upgrading jobs.", (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            __log.debug((Object)"UPGRADE complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverStaleNode(final String string) {
        __log.debug((Object)("recovering stale node " + string));
        try {
            int n = this.execTransaction(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return SimpleScheduler.this._db.updateReassign(string, SimpleScheduler.this._nodeId);
                }
            });
            __log.debug((Object)("reassigned " + n + " jobs to self. "));
            this._knownNodes.remove(string);
            this._lastHeartBeat.remove(string);
            this.doLoadImmediate();
        }
        catch (Exception exception) {
            __log.error((Object)"Database error reassigning node.", (Throwable)exception);
        }
        finally {
            __log.debug((Object)"node recovery complete");
        }
    }

    private long doRetry(Job job) throws DatabaseException {
        int n = job.detail.get("retry") != null ? (Integer)job.detail.get("retry") + 1 : 0;
        job.detail.put("retry", n);
        long l = (long)Math.pow(5.0, n);
        if (l > 86400L) {
            l = 86400L;
        }
        Job job2 = new Job(System.currentTimeMillis() + l * 1000L, true, job.detail);
        this._db.insertJob(job2, this._nodeId, false);
        return l;
    }

    private class CheckStaleNodes
    extends SchedulerTask {
        CheckStaleNodes(long l) {
            super(l);
        }

        public void run() {
            SimpleScheduler.this._todo.enqueue(new CheckStaleNodes(System.currentTimeMillis() + SimpleScheduler.this._staleInterval));
            __log.debug((Object)"CHECK STALE NODES started");
            for (String string : SimpleScheduler.this._knownNodes) {
                Long l = (Long)SimpleScheduler.this._lastHeartBeat.get(string);
                if (l != null && System.currentTimeMillis() - l <= SimpleScheduler.this._staleInterval) continue;
                SimpleScheduler.this.recoverStaleNode(string);
            }
        }
    }

    private class UpgradeJobsTask
    extends SchedulerTask {
        UpgradeJobsTask(long l) {
            super(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            long l2 = SimpleScheduler.this._nextUpgrade.get();
            __log.debug((Object)("UPGRADE task for " + this.schedDate + " fired at " + l));
            if (SimpleScheduler.this._nextUpgrade.get() > System.currentTimeMillis()) {
                __log.debug((Object)("UPGRADE skipped -- wait another " + (l2 - l) + "ms"));
                SimpleScheduler.this._todo.enqueue(new UpgradeJobsTask(l2));
                return;
            }
            boolean bl = false;
            try {
                bl = SimpleScheduler.this.doUpgrade();
            }
            catch (Throwable throwable) {
                long l3 = System.currentTimeMillis() + (bl ? (long)((double)SimpleScheduler.this._nearFutureInterval * 0.5) : 100L);
                SimpleScheduler.this._nextUpgrade.set(l3);
                SimpleScheduler.this._todo.enqueue(new UpgradeJobsTask(l3));
                __log.debug((Object)("UPGRADE completed, success = " + bl + "; next time in " + (l3 - l) + "ms"));
                throw throwable;
            }
            long l4 = System.currentTimeMillis() + (bl ? (long)((double)SimpleScheduler.this._nearFutureInterval * 0.5) : 100L);
            SimpleScheduler.this._nextUpgrade.set(l4);
            SimpleScheduler.this._todo.enqueue(new UpgradeJobsTask(l4));
            __log.debug((Object)("UPGRADE completed, success = " + bl + "; next time in " + (l4 - l) + "ms"));
        }
    }

    private class LoadImmediateTask
    extends SchedulerTask {
        LoadImmediateTask(long l) {
            super(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            try {
                bl = SimpleScheduler.this.doLoadImmediate();
            }
            finally {
                if (bl) {
                    SimpleScheduler.this._todo.enqueue(new LoadImmediateTask(System.currentTimeMillis() + (long)((double)SimpleScheduler.this._immediateInterval * 0.75)));
                } else {
                    SimpleScheduler.this._todo.enqueue(new LoadImmediateTask(System.currentTimeMillis() + 100L));
                }
            }
        }
    }

    private abstract class SchedulerTask
    extends Task
    implements Runnable {
        SchedulerTask(long l) {
            super(l);
        }
    }
}

