/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.util;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.smila.http.server.HttpExchange;

public final class CorsUtils {
    public static boolean setCorsResponseHandlers(HttpExchange he) throws IOException {
        String requestedMethod;
        String origin = he.getRequestHeader("Origin");
        if (origin == null) {
            origin = "*";
        }
        he.setResponseHeader("Access-Control-Allow-Origin", origin);
        he.setResponseHeader("Access-Control-Allow-Credentials", "true");
        if ("OPTIONS".equals(he.getRequestMethod()) && (requestedMethod = he.getRequestHeader("Access-Control-Request-Method")) != null) {
            he.setResponseHeader("Access-Control-Allow-Methods", requestedMethod);
            he.setResponseHeader("Access-Control-Max-Age", "1728000");
            String customHeaders = he.getRequestHeader("Access-Control-Request-Headers");
            if (customHeaders != null) {
                he.setResponseHeader("Access-Control-Allow-Headers", customHeaders);
            }
            he.setResponseStatus(200);
            he.getResponseStream().flush();
            return true;
        }
        return false;
    }

    public static void setCorsResponseHandlers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String origin = request.getHeader("Origin");
        if (origin == null) {
            origin = "*";
        }
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Expose-Headers", "WWW-Authenticate,Access-Control-Allow-Origin,Access-Control-Allow-Credentials");
    }
}

