/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore;

/**
 * Thrown to indicate that the given store name does not conform to the restrictions imposed by the service
 * implementation.
 */
public class InvalidStoreNameException extends BadRequestException {
  /** because it's serializable ... */
  private static final long serialVersionUID = 1L;

  /** create exception with description and causing exception. */
  public InvalidStoreNameException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /** create exception with description only. */
  public InvalidStoreNameException(final String message) {
    super(message);
  }

  /** create exception from causing exception. */
  public InvalidStoreNameException(final Throwable cause) {
    super(cause);
  }

}
