/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/

package org.eclipse.smila.jobmanager;

import java.util.List;

import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.taskmanager.Task;

/**
 * Job management component for handling tasks and workflow runs.
 */
public interface JobTaskProcessor {
  /**
   * Finishes a task and retrieves the following tasks. Dependent on the resultDescription job manager can decide what
   * to do.
   * 
   * @param currentTask
   *          The finished task.
   * @return A list of follow up tasks. If there are no follow-up tasks, an empty list will be generated.
   * @throws JobManagerException
   *           error while trying to finish the task.
   */
  List<Task> finishTask(Task currentTask) throws JobManagerException;

  /**
   * Creates an initial task for input-workers.
   * 
   * @param workerName
   *          The name of the worker for which this task is requested.
   * @param id
   *          The id of the task-source (e.g. index name, job id, ...) for which the task is requested. The TaskProducer
   *          and the worker requester of the tasks should have a common understanding of what this id is about.
   * @return A task for the worker or null if task delivery is currently not allowed for this id.
   * @throws JobManagerException
   *           error while trying to generate initial task. The job has not the correct state or the worker is not an
   *           startAction worker.
   */
  Task getInitialTask(String workerName, String id) throws JobManagerException;

}
