/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.datamodel.validation;

import org.eclipse.smila.datamodel.Record;

/**
 * interface of record validation services. Such services check if a record pushed into the system conforms to some
 * specific requirements, e.g. index schemata or other requirements that processing components might have.
 */
public interface RecordValidator {
  /**
   * check validity of the given record.
   */
  void validate(final Record record) throws InvalidRecordException;
}
