package org.apache.solr.util.stats;

public abstract class Clock {

  public abstract long getTick();

  public long getTime() {
    return 0;
  }

  private static final Clock DEFAULT = new UserTimeClock();

  public static Clock defaultClock() {
    return DEFAULT;
  }

  public static class UserTimeClock extends Clock {
    @Override
    public long getTick() {
      return 0;
    }
  }

  public static class CpuTimeClock extends Clock {
    @Override
    public long getTick() {
      return 0;
    }
  }

}
