/**
 *
 */
package org.eclipse.smila.solr.httphandler;

import org.apache.solr.common.params.CoreAdminParams.CoreAdminAction;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.URLCreator;

/**
 * @author pwissel
 *
 */
public class CoreAdminHandler extends AAdminHandler {

  @Override
  Any doGet(final HttpExchange exchange, final String requestUri) throws Exception {
    final String requestHost = getRequestHost(exchange);
    final AnyMap result = FACTORY.createAnyMap();
    final AnySeq usage = result.getSeq("usage", true);
    for (final CoreAdminAction value : CoreAdminAction.values()) {
      final AnyMap action = FACTORY.createAnyMap();
      action.put("name", value.name());
      final String rootContextPath = getRootContextPath();
      final String staticUriPart = getStaticUriPart(requestUri);
      final String uri = rootContextPath + staticUriPart;
      final String pathToAppend = value.toString().toLowerCase();
      final String url = URLCreator.create(requestHost, uri, pathToAppend).toString();
      action.put("url", url);
      usage.add(action);
    }
    return result;
  }

}
