/**
 *
 */
package org.eclipse.smila.solr.server;

import java.net.MalformedURLException;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.eclipse.smila.solr.SolrConfig;

/**
 * @author pwissel
 *
 */
public class CloudServers extends SolrServers {

  public CloudServers(final SolrConfig config) {
    super(config);
  }

  /*
   * (non-Javadoc)
   *
   * @see org.eclipse.smila.solr.server.SolrServers#createServer(java.lang.String)
   */
  @Override
  protected SolrServer createServer(final String index) throws MalformedURLException {
    final CloudSolrServer server = (CloudSolrServer) createServer();
    final String idField = getConfig().getIdField(index);
    server.setIdField(idField);
    server.setDefaultCollection(index);
    return server;
  }

  @Override
  protected SolrServer createServer() throws MalformedURLException {
    final String zkHost = getConfig().getCloudSolrServerZkHost();
    final boolean updatesToLeaders = getConfig().getCloudSolrServerUpdatesToLeaders();
    return new CloudSolrServer(zkHost, updatesToLeaders);
  }

}
