/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.xmlprocessing.AXmlTransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XPathUtils;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathFilterPipelet
extends AXmlTransformationPipelet {
    public static final String PROP_XPATH = "xpath";
    public static final String PROP_FILTER_MODE = "filterMode";
    public static final String PROP_SEPARATOR = "separator";
    public static final String PROP_NAMESPACE = "namespace";
    public static final String PROP_ROOT_ELEMENT = "rootElement";

    @Override
    protected void processRecord(Blackboard blackboard, ParameterAccessor paramAccessor, String id) throws Exception {
        Any xpaths = paramAccessor.getParameterAny(PROP_XPATH);
        if (xpaths == null || xpaths.size() == 0) {
            throw new ProcessingException("Property xpath must not be <null> or an empty String");
        }
        String mode = paramAccessor.getParameter(PROP_FILTER_MODE, null);
        XPathFilterMode filterMode = XPathFilterMode.INCLUDE;
        if (mode != null) {
            filterMode = XPathFilterMode.valueOf(mode);
        }
        String root = null;
        if (XPathFilterMode.INCLUDE.equals((Object)filterMode)) {
            root = paramAccessor.getRequiredParameter(PROP_ROOT_ELEMENT);
        }
        String namespace = paramAccessor.getParameter(PROP_NAMESPACE, "");
        Element namespaceElement = this.createNamespaceElement(namespace);
        Document inputDocument = this.createDocument(blackboard, id, paramAccessor);
        if (inputDocument != null) {
            Document result = XPathFilterMode.INCLUDE.equals((Object)filterMode) ? this.includeElements(inputDocument, xpaths, namespaceElement, root) : this.excludeElements(inputDocument, xpaths, namespaceElement);
            this.storeDocument(blackboard, id, result, paramAccessor);
        }
    }

    private Document includeElements(Document inputDocument, Any xpaths, Element namespaceElement, String root) throws ProcessingException {
        Document doc = XMLUtils.getDocument();
        Element rootElement = doc.createElement(root);
        doc.appendChild(rootElement);
        try {
            for (Any xpath : xpaths) {
                XObject xobj = XPathAPI.eval((Node)inputDocument, (String)((Value)xpath).asString(), (Node)namespaceElement);
                NodeList nl = xobj.nodelist();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n = nl.item(i);
                    rootElement.appendChild(doc.importNode(n, true));
                    ++i;
                }
            }
        }
        catch (TransformerException e) {
            throw new ProcessingException("Transformer exception: " + e.getMessage());
        }
        return doc;
    }

    private Document excludeElements(Document inputDocument, Any xpaths, Element namespaceElement) {
        for (Any xpath : xpaths) {
            XPathUtils.removeNodesByXPath(inputDocument, ((Value)xpath).asString(), namespaceElement);
        }
        return inputDocument;
    }

    private Element createNamespaceElement(String namespace) throws ProcessingException {
        Document doc = XMLUtils.getDocument();
        Element namespaceElement = doc.createElement("NamespaceDef");
        String[] namespaces = namespace.split(" ");
        int i = 0;
        while (i < namespaces.length) {
            if (!"".equals(namespaces[i].trim())) {
                String[] nsItems = namespaces[i].split("=");
                if (nsItems.length != 2) {
                    throw new ProcessingException("Property namespace in invalid format [Namespace;ns1=val ns2=val]");
                }
                namespaceElement.setAttribute("xmlns:" + nsItems[0], nsItems[1]);
            }
            ++i;
        }
        return namespaceElement;
    }

    public static enum XPathFilterMode {
        INCLUDE,
        EXCLUDE;

    }
}

