/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.utils.xml.stax.XmlSnippetHandler;
import org.eclipse.smila.utils.xml.stax.XmlSnippetSplitter;

public class XmlDocumentSplitterPipelet
extends ATransformationPipelet {
    public static final String PROP_BEGIN_TAG_NAME = "beginTagName";
    public static final String PROP_BEGIN_TAG_NAMESPACE = "beginTagNamespace";
    public static final String PROP_END_TAG_NAME = "endTagName";
    public static final String PROP_END_TAG_NAMESPACE = "endTagNamespace";

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds == null) {
            return recordIds;
        }
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                paramAccessor.setCurrentRecord(id);
                String beginTagName = paramAccessor.getRequiredParameter(PROP_BEGIN_TAG_NAME);
                String beginTagNamespace = paramAccessor.getParameter(PROP_BEGIN_TAG_NAMESPACE, "");
                String endTagName = paramAccessor.getParameter(PROP_END_TAG_NAME, beginTagName);
                String endTagNamespace = paramAccessor.getParameter(PROP_END_TAG_NAMESPACE, beginTagNamespace);
                QName beginTag = new QName(beginTagNamespace, beginTagName);
                QName endTag = new QName(endTagNamespace, endTagName);
                String outputName = this.getOutputName(paramAccessor);
                boolean storeInAttribute = this.isStoreInAttribute(this.getOutputType(paramAccessor));
                InternalHandler snippetHandler = new InternalHandler(blackboard, id, outputName, storeInAttribute, resultCollector);
                XmlSnippetSplitter splitter = new XmlSnippetSplitter((XmlSnippetHandler)snippetHandler, beginTag, endTag);
                InputStream inputStream = this.getXmlInputStream(blackboard, id, paramAccessor);
                splitter.read(inputStream);
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("Created " + snippetHandler.getRecordCount() + " records from processing record " + id));
                }
            }
            catch (Exception e) {
                resultCollector.addFailedResult(id, e);
            }
            ++n2;
        }
        return resultCollector.getResultIds();
    }

    private InputStream getXmlInputStream(Blackboard blackboard, String id, ParameterAccessor paramAccessor) throws IOException, BlackboardAccessException, MissingParameterException {
        InputStream inputStream = null;
        inputStream = this.isReadFromAttribute(this.getInputType(paramAccessor)) ? this.loadExternalInputStream(this.readStringInput(blackboard, id, paramAccessor)) : blackboard.getAttachmentAsStream(id, this.getInputName(paramAccessor));
        return inputStream;
    }

    private InputStream loadExternalInputStream(String attrtibuteValue) throws IOException {
        InputStream stream = null;
        if (attrtibuteValue != null && attrtibuteValue.trim().length() > 0) {
            if (attrtibuteValue.startsWith("file")) {
                URL url = new URL(attrtibuteValue);
                stream = new FileInputStream(String.valueOf(url.getAuthority()) + url.getPath());
            } else if (attrtibuteValue.startsWith("http")) {
                URL url = new URL(attrtibuteValue);
                HttpClient httpClient = new HttpClient();
                GetMethod getMethod = new GetMethod(url.toString());
                httpClient.executeMethod((HttpMethod)getMethod);
                stream = getMethod.getResponseBodyAsStream();
            } else {
                stream = new FileInputStream(attrtibuteValue);
            }
        }
        return stream;
    }

    class InternalHandler
    implements XmlSnippetHandler {
        private final Blackboard _blackboard;
        private final String _currentId;
        private final ResultCollector _resultCollector;
        private final String _outputName;
        private final boolean _storeInAttribute;
        private final AnyMap _cloneMetadata = DataFactory.DEFAULT.createAnyMap();
        private int _recordCount;

        private InternalHandler(Blackboard blackboard, String currentId, String outputName, boolean storeInAttribute, ResultCollector resultCollector) throws BlackboardAccessException {
            this._blackboard = blackboard;
            this._currentId = currentId;
            this._outputName = outputName;
            this._storeInAttribute = storeInAttribute;
            this._resultCollector = resultCollector;
            this._cloneMetadata.putAll((Map)this._blackboard.getMetadata(this._currentId));
            this._cloneMetadata.remove((Object)"_recordid");
        }

        public int getRecordCount() {
            return this._recordCount;
        }

        public void handleSnippet(byte[] snippet) {
            String snippetId = String.valueOf(this._currentId) + "###" + this._recordCount++;
            try {
                Record snippetRecord = this._blackboard.getRecord(snippetId, Blackboard.Get.NEW);
                snippetRecord.getMetadata().put("_documentId", this._currentId);
                snippetRecord.getMetadata().putAll((Map)this._cloneMetadata);
                if (this._storeInAttribute) {
                    snippetRecord.getMetadata().put(this._outputName, new String(snippet, ENCODING_CHARSET));
                } else {
                    this._blackboard.setAttachment(snippetId, this._outputName, snippet);
                }
                this._resultCollector.addResult(snippetId);
            }
            catch (Exception ex) {
                XmlDocumentSplitterPipelet.this._log.warn((Object)"Error creating XML-snippet record", (Throwable)ex);
            }
        }
    }
}

