/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XslException;
import org.eclipse.smila.utils.xml.XMLUtilsException;
import org.w3c.dom.Document;

public class XslTransformer {
    private static TransformerFactory s_transformerFactory = TransformerFactory.newInstance();
    private final Hashtable<String, SubTemplates> _templates = new Hashtable();

    public StreamResult transform(Document document, String xslFile, AnyMap parameters) throws XslException, XMLUtilsException, IOException {
        try {
            Transformer transformer = this.createTransformer(xslFile);
            if (parameters != null) {
                for (Map.Entry entry : parameters.entrySet()) {
                    if (!((Any)entry.getValue()).isValue()) continue;
                    transformer.setParameter((String)entry.getKey(), ((Any)entry.getValue()).asValue().asString());
                }
            }
            DOMSource source = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return result;
        }
        catch (TransformerException e) {
            throw new XslException(e);
        }
    }

    private Transformer createTransformer(String xslFile) throws XslException, IOException {
        SubTemplates subTemplates = this._templates.get(xslFile);
        try {
            File file = new File(xslFile);
            if (!file.exists()) {
                throw new FileNotFoundException(xslFile);
            }
            if (subTemplates == null || subTemplates.getTimestamp() != file.lastModified()) {
                StreamSource source = new StreamSource(file);
                Templates template = s_transformerFactory.newTemplates(source);
                SubTemplates newSubTemplates = new SubTemplates(template, file.lastModified());
                this._templates.put(xslFile, newSubTemplates);
                subTemplates = newSubTemplates;
            }
            return subTemplates.getTemplates().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new XslException(e);
        }
    }

    private static class SubTemplates {
        private final Templates _xslTemplates;
        private final long _timestamp;

        public SubTemplates(Templates templates, long timestamp) {
            this._xslTemplates = templates;
            this._timestamp = timestamp;
        }

        public Templates getTemplates() {
            return this._xslTemplates;
        }

        public long getTimestamp() {
            return this._timestamp;
        }
    }
}

