/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ValueFormatHelper {
    public static final ValueFormatHelper INSTANCE = new ValueFormatHelper();
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final int DATE_LENGTH = "yyyy-MM-dd".length();
    private static final int DATE_TIME_LENGTH_PATTERN_DEFAULT = 28;
    private static final int DATE_TIME_LENGTH_PATTERN_SHORT_Z = 20;
    private static final int DATE_TIME_LENGTH_PATTERN_LONG_Z = 24;
    private static final int DATE_TIME_LENGTH_PATTERN_2 = 22;
    private static final int DATE_TIME_LENGTH_PATTERN_3 = 24;
    private static final int DATE_TIME_LENGTH_PATTERN_4 = 25;
    private static final int DATE_TIME_LENGTH_PATTERN_5 = 26;
    private static final int DATE_TIME_LENGTH_PATTERN_6 = 28;
    private static final int DATE_TIME_LENGTH_PATTERN_7 = 29;
    private final DateFormat _formatDate = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat _formatDateTimePatternDefault = ValueFormatHelper.getDefaultDateTimeFormat();
    private final DateFormat _formatDateTimePattern2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    private final DateFormat _formatDateTimePattern3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
    private final DateFormat _formatDateTimePattern4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    private final DateFormat _formatDateTimePattern5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    private final DateFormat _formatDateTimePattern6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
    private final DateFormat _formatDateTimePattern7 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private final Pattern _formatPatternDateDefault = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private final Pattern _formatPatternDateTimeDefault = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]{1}\\d{4}");
    private final Pattern _formatPatternDateTimeShortZ = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z");
    private final Pattern _formatPatternDateTimeLongZ = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}Z");
    private final Pattern _formatPatternDateTime2 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+-]\\d{2}");
    private final Pattern _formatPatternDateTime3 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+-]\\d{4}");
    private final Pattern _formatPatternDateTime4 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+-]\\d{2}:\\d{2}");
    private final Pattern _formatPatternDateTime5 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{2}");
    private final Pattern _formatPatternDateTime6 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{4}");
    private final Pattern _formatPatternDateTime7 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{2}:\\d{2}");

    public ValueFormatHelper() {
        this._formatDate.setLenient(false);
        this._formatDateTimePatternDefault.setLenient(false);
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        this._formatDateTimePattern2.setLenient(false);
        this._formatDateTimePattern2.setTimeZone(utcTimeZone);
        this._formatDateTimePattern3.setLenient(false);
        this._formatDateTimePattern3.setTimeZone(utcTimeZone);
        this._formatDateTimePattern4.setLenient(false);
        this._formatDateTimePattern4.setTimeZone(utcTimeZone);
        this._formatDateTimePattern5.setLenient(false);
        this._formatDateTimePattern5.setTimeZone(utcTimeZone);
        this._formatDateTimePattern6.setLenient(false);
        this._formatDateTimePattern6.setTimeZone(utcTimeZone);
        this._formatDateTimePattern7.setLenient(false);
        this._formatDateTimePattern7.setTimeZone(utcTimeZone);
    }

    public static SimpleDateFormat getDefaultDateTimeFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        sdf.setLenient(false);
        return sdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDate(Date value) {
        DateFormat dateFormat = this._formatDate;
        synchronized (dateFormat) {
            return this._formatDate.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDateTime(Date value) {
        DateFormat dateFormat = this._formatDateTimePatternDefault;
        synchronized (dateFormat) {
            return this._formatDateTimePatternDefault.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseDate(String dateString) throws ParseException {
        if (dateString.length() == DATE_LENGTH && this._formatPatternDateDefault.matcher(dateString).matches()) {
            DateFormat dateFormat = this._formatDate;
            synchronized (dateFormat) {
                return this._formatDate.parse(dateString);
            }
        }
        throw new ParseException("Pattern of string '" + dateString + "' doesn't match supported date pattern " + DATE_PATTERN, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date tryParseDate(String dateString) {
        if (dateString.length() == DATE_LENGTH && this._formatPatternDateDefault.matcher(dateString).matches()) {
            DateFormat dateFormat = this._formatDate;
            synchronized (dateFormat) {
                try {
                    return this._formatDate.parse(dateString);
                }
                catch (ParseException parseException) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseDateTimeInternal(String dateTimeString) throws ParseException {
        Date result = null;
        int dateLen = dateTimeString.length();
        if (dateLen == 28 && this._formatPatternDateTimeDefault.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePatternDefault;
            synchronized (dateFormat) {
                result = this._formatDateTimePatternDefault.parse(dateTimeString);
            }
        }
        if (dateLen == 20 && this._formatPatternDateTimeShortZ.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern2;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern2.parse(dateTimeString);
            }
        }
        if (dateLen == 24 && this._formatPatternDateTimeLongZ.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern5;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern5.parse(dateTimeString);
            }
        }
        if (dateLen == 22 && this._formatPatternDateTime2.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern2;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern2.parse(dateTimeString);
            }
        }
        if (dateLen == 24 && this._formatPatternDateTime3.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern3;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern3.parse(dateTimeString);
            }
        }
        if (dateLen == 25 && this._formatPatternDateTime4.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern4;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern4.parse(dateTimeString);
            }
        }
        if (dateLen == 26 && this._formatPatternDateTime5.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern5;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern5.parse(dateTimeString);
            }
        }
        if (dateLen == 28 && this._formatPatternDateTime6.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern6;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern6.parse(dateTimeString);
            }
        }
        if (dateLen == 29 && this._formatPatternDateTime7.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern7;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern7.parse(dateTimeString);
            }
        }
        return result;
    }

    public Date parseDateTime(String dateTimeString) throws ParseException {
        Date result = this.parseDateTimeInternal(dateTimeString);
        if (result == null) {
            throw new ParseException("Pattern of datetime string '" + dateTimeString + "' doesn't match supported patterns", 0);
        }
        return result;
    }

    public Date tryParseDateTime(String dateTimeString) {
        Date result = null;
        int strLen = dateTimeString.length();
        if (strLen < DATE_LENGTH || strLen > 29) {
            return null;
        }
        if (strLen > 20 && !dateTimeString.substring(10, 11).equals("T")) {
            return null;
        }
        try {
            result = this.parseDateTimeInternal(dateTimeString);
        }
        catch (ParseException parseException) {}
        return result;
    }
}

