/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.ipc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.ipc.IpcFactory;
import org.eclipse.smila.ipc.IpcStreamReader;
import org.eclipse.smila.ipc.IpcToken;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.ipc.json.JsonFactory;

public class IpcAnyReader {
    public static final String ENCODING = "UTF-8";
    private final IpcFactory _binaryFactory = new BinaryFactory();
    private final IpcFactory _jsonFactory = new JsonFactory();

    public Any readBinaryObject(byte[] binary) throws IOException {
        Any any;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(binary);
            any = this.readBinaryStream(bais);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return any;
    }

    public Any readEmbeddedBinaryAny(byte[] binary) throws IOException {
        IpcToken token;
        IpcStreamReader reader;
        ByteArrayInputStream bais;
        block3: {
            bais = null;
            try {
                bais = new ByteArrayInputStream(binary);
                reader = this._binaryFactory.newStreamReader((InputStream)bais);
                token = reader.nextToken();
                if (token != null) break block3;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bais);
            return null;
        }
        Any any = this.readAny(reader, token);
        IOUtils.closeQuietly((InputStream)bais);
        return any;
    }

    public Any readBinaryStream(InputStream stream) throws IOException {
        IpcStreamReader reader = this._binaryFactory.newStreamReader(stream);
        return this.readStream(reader);
    }

    public Any readJsonObject(String json) throws IOException {
        Any any;
        ByteArrayInputStream jsonStream = null;
        try {
            jsonStream = new ByteArrayInputStream(json.getBytes(ENCODING));
            any = this.readJsonStream(jsonStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(jsonStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)jsonStream);
        return any;
    }

    public Any readJsonStream(InputStream stream) throws IOException {
        IpcStreamReader reader = this._jsonFactory.newStreamReader(stream);
        try {
            Any any = this.readStream(reader);
            return any;
        }
        finally {
            reader.closeWithoutStream();
        }
    }

    public Any readStream(IpcStreamReader reader) throws IOException {
        Any any;
        IpcToken token = reader.nextToken();
        if (token == null) {
            return null;
        }
        if (token != IpcToken.OBJECT_START) {
            throw new IllegalStateException("Expected OBJECT_START Token; Token = " + token);
        }
        token = reader.nextToken();
        if (token != IpcToken.OBJECT_END) {
            any = this.readAny(reader, token);
            token = reader.nextToken();
        } else {
            any = null;
        }
        if (token != IpcToken.OBJECT_END) {
            throw new IllegalStateException("Expected OBJECT_END Token; Token = " + token);
        }
        return any;
    }

    private Any readAny(IpcStreamReader reader, IpcToken token) throws IOException {
        Any any = null;
        switch (token) {
            case MAPPING_START: {
                any = this.readMap(reader);
                break;
            }
            case SEQUENCE_START: {
                any = this.readSeq(reader);
                break;
            }
            default: {
                any = this.readValue(reader, token);
            }
        }
        return any;
    }

    AnyMap readMap(IpcStreamReader reader) throws IOException {
        IpcToken token;
        AnyMap map = DataFactory.DEFAULT.createAnyMap();
        while ((token = reader.nextToken()) != IpcToken.MAPPING_END) {
            if (token != IpcToken.SCALAR_STRING) {
                throw new IllegalStateException("Expected SCALAR_STRING Token; Token = " + token);
            }
            String key = reader.currentStringValue();
            map.put(key, this.readAny(reader, reader.nextToken()));
        }
        return map;
    }

    private AnySeq readSeq(IpcStreamReader reader) throws IOException {
        AnySeq anySeq = DataFactory.DEFAULT.createAnySeq();
        IpcToken token = null;
        while ((token = reader.nextToken()) != IpcToken.SEQUENCE_END) {
            anySeq.add(this.readAny(reader, token));
        }
        return anySeq;
    }

    private Value readValue(IpcStreamReader reader, IpcToken token) throws IOException {
        Value value = null;
        switch (token) {
            case SCALAR_BOOL: {
                value = DataFactory.DEFAULT.createBooleanValue(reader.currentBoolValue());
                break;
            }
            case SCALAR_DOUBLE: {
                value = DataFactory.DEFAULT.createDoubleValue(reader.currentDoubleValue());
                break;
            }
            case SCALAR_INT: {
                value = DataFactory.DEFAULT.createLongValue(reader.currentLongValue());
                break;
            }
            default: {
                value = DataFactory.DEFAULT.tryDateTimestampParsingFromString(reader.currentStringValue());
            }
        }
        return value;
    }
}

