/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.string;

import org.eclipse.core.runtime.Assert;

public final class StringTypesUtils {
    private StringTypesUtils() {
    }

    public static StringBuilder setLengthRelative(StringBuilder sb, int len) {
        int newLength = sb.length() + len;
        sb.setLength(Math.max(0, newLength));
        return sb;
    }

    public static CharSequence right(StringBuilder sb, int len) {
        int offset = Math.max(0, sb.length() - len);
        return sb.subSequence(offset, sb.length());
    }

    public static char lastChar(StringBuilder sb) {
        return sb.charAt(sb.length());
    }

    public static void replaceEnd(StringBuilder sb, int reverseOffsetFromEnd, CharSequence string) {
        int start = sb.length() - reverseOffsetFromEnd;
        sb.setLength(start);
        sb.append(string);
    }

    public static void assertWhitespaceFree(CharSequence value, String valueDescription) {
        StringTypesUtils.assertWhitespaceFree(value, "illegal whitespace detected in %s: %s", valueDescription, value);
    }

    public static void assertWhitespaceFree(CharSequence value, String formatString, Object ... formatObjects) {
        boolean found = false;
        int i = 0;
        while (i < value.length()) {
            if (Character.isWhitespace(value.charAt(i))) {
                found = true;
                break;
            }
            ++i;
        }
        Assert.isTrue((!found ? 1 : 0) != 0, (String)String.format(formatString, formatObjects));
    }
}

