/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RegexPatternMatcher {
    private final List<Pattern> _includePatterns = new ArrayList<Pattern>();
    private final List<Pattern> _excludePatterns = new ArrayList<Pattern>();

    public boolean matches(String input) {
        for (Pattern exclude : this._excludePatterns) {
            if (!exclude.matcher(input).matches()) continue;
            return false;
        }
        if (this._includePatterns.isEmpty()) {
            return true;
        }
        for (Pattern include : this._includePatterns) {
            if (!include.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(String input) {
        if (this._includePatterns.isEmpty()) {
            return true;
        }
        for (Pattern include : this._includePatterns) {
            if (!include.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(String input) {
        for (Pattern exclude : this._excludePatterns) {
            if (!exclude.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    public void addIncludePattern(String regex) {
        Pattern p = Pattern.compile(regex);
        this._includePatterns.add(p);
    }

    public void addExcludePattern(String regex) {
        Pattern p = Pattern.compile(regex);
        this._excludePatterns.add(p);
    }
}

