/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.zookeeper.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.clusterconfig.ClusterConfigException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.datamodel.ipc.IpcRecordWriter;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.zookeeper.ZkConnection;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class ZooKeeperAdminHandler
extends JsonRequestHandler {
    public static final String KEY_SET_WATCH = "setWatch";
    public static final String KEY_DATA = "data";
    private ZooKeeperService _zkService;
    private ZkConnection _zkConnection;
    private final IpcRecordReader _ipcRecordReader = new IpcRecordReader();
    private final IpcRecordWriter _ipcRecordWriter = new IpcRecordWriter();
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected boolean isValidMethod(String method, String requestUri) {
        return "GET".equals(method) || "PUT".equals(method) || "DELETE".equals(method);
    }

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        String path = this.getPath(requestUri);
        Record result = FACTORY.createRecord();
        ZooKeeper client = this._zkService.getClient();
        if ("GET".equals(method)) {
            boolean setWatch = inputRecord != null && inputRecord.getMetadata().containsKey((Object)KEY_SET_WATCH) ? inputRecord.getMetadata().getBooleanValue(KEY_SET_WATCH) : false;
            Stat stat = client.exists(path, setWatch);
            if (stat != null) {
                result.getMetadata().put("stat", (Any)this.convertStat(stat));
                if (stat.getDataLength() > 0) {
                    result.getMetadata().put(KEY_DATA, this.getData(client, path));
                }
                if (stat.getNumChildren() > 0) {
                    result.getMetadata().put("children", (Any)this.getChildren(client, path, requestUri, this.getRequestHost(exchange)));
                }
            }
        } else if ("PUT".equals(method)) {
            byte[] data = inputRecord != null ? this._ipcRecordWriter.writeBinaryObject(inputRecord) : new byte[]{};
            try {
                this._zkConnection.createPath(path, data);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                this._zkConnection.setData(path, data);
            }
        } else if ("DELETE".equals(method)) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("Deleting zookeeper path: " + path));
            }
            this._zkConnection.deleteTree(path);
        }
        return result;
    }

    private Any getData(ZooKeeper client, String path) {
        byte[] data;
        try {
            data = client.getData(path, false, null);
        }
        catch (Exception ex) {
            return FACTORY.createStringValue("Failed to read data: " + ex.toString());
        }
        try {
            Record record = this._ipcRecordReader.readBinaryObject(data);
            return record.getMetadata();
        }
        catch (Exception exception) {
            try {
                Record record = this._ipcRecordReader.readJsonStream((InputStream)new ByteArrayInputStream(data));
                return record.getMetadata();
            }
            catch (Exception exception2) {
                try {
                    return FACTORY.createStringValue(new String(data, "utf-8"));
                }
                catch (Exception exception3) {
                    return FACTORY.createStringValue("Data not in BON or JSON format, nor a UTF-8 string.");
                }
            }
        }
    }

    private AnySeq getChildren(ZooKeeper client, String path, String requestUri, String requestHost) throws KeeperException, InterruptedException, MalformedURLException {
        List children = client.getChildren(path, false);
        AnySeq result = FACTORY.createAnySeq();
        int i = 0;
        while (i < children.size()) {
            URL url = URLCreator.create((String)requestHost, (String)requestUri, (String)((String)children.get(i)));
            result.add(url.toString());
            ++i;
        }
        return result;
    }

    private AnyMap convertStat(Stat stat) {
        AnyMap map = FACTORY.createAnyMap();
        map.put("a-version", (Number)stat.getAversion());
        map.put("c-time", (Any)FACTORY.createDateTimeValue(new Date(stat.getCtime())));
        map.put("c-version", (Number)stat.getCversion());
        map.put("c-zxid", (Number)stat.getCzxid());
        map.put("data-length", (Number)stat.getDataLength());
        map.put("ephemeral-owner", (Number)stat.getEphemeralOwner());
        map.put("m-time", (Any)FACTORY.createDateTimeValue(new Date(stat.getMtime())));
        map.put("m-zxid", (Number)stat.getMzxid());
        map.put("num-children", (Number)stat.getNumChildren());
        map.put("p-zxid", (Number)stat.getPzxid());
        map.put("version", (Number)stat.getVersion());
        return map;
    }

    protected String getPath(String requestUri) {
        String path = "/";
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            path = (String)uriParts.get(0);
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.length() > 1 && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public void setZooKeeperService(ZooKeeperService zooKeeperService) {
        this._zkService = zooKeeperService;
        this._zkConnection = new ZkConnection(this._zkService);
    }

    public void unsetZooKeeperService(ZooKeeperService zooKeeperService) {
        if (this._zkService == zooKeeperService) {
            this._zkService = null;
            try {
                this._zkConnection.disconnectZkSession();
            }
            catch (IOException e) {
                this._log.error((Object)"Cannot disconnect Zookeeper session.", (Throwable)e);
            }
            catch (ClusterConfigException e) {
                this._log.error((Object)"Cannot disconnect Zookeeper session.", (Throwable)e);
            }
            this._zkConnection = null;
        }
    }
}

