/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.fs;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static final Log __log = LogFactory.getLog(FileUtils.class);

    public static boolean isAbsolute(String string) {
        return new File(string).isAbsolute();
    }

    public static boolean isRelative(String string) {
        return !FileUtils.isAbsolute(string);
    }

    public static boolean deepDelete(File file) {
        if (file.exists()) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("deleting: " + file.getAbsolutePath()));
            }
            if (file.delete()) {
                return true;
            }
            if (file.isDirectory()) {
                boolean bl = true;
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    bl &= FileUtils.deepDelete(fileArray[i]);
                }
                return bl ? file.delete() : false;
            }
            __log.error((Object)("Unable to deepDelete file " + file.getAbsolutePath() + "; this may be caused by a descriptor leak and should be reported."));
            return false;
        }
        return true;
    }

    public static List<File> directoryEntriesInPath(File file) {
        return FileUtils.directoryEntriesInPath(file, null);
    }

    public static List<File> directoryEntriesInPath(File file, FileFilter fileFilter) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist!");
        }
        ArrayList<File> arrayList = new ArrayList<File>(32);
        if (file.isFile()) {
            if (fileFilter == null || fileFilter != null && fileFilter.accept(file)) {
                arrayList.add(file);
            }
            return arrayList;
        }
        FileUtils.directoryEntriesInPath(arrayList, file, fileFilter);
        return arrayList;
    }

    private static void directoryEntriesInPath(List<File> list, File file, FileFilter fileFilter) {
        File[] fileArray;
        if (fileFilter == null || fileFilter != null && fileFilter.accept(file)) {
            list.add(file);
        }
        if ((fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (fileFilter == null || fileFilter != null && fileFilter.accept(file2)) {
                    list.add(file2);
                }
                if (!file2.isDirectory()) continue;
                FileUtils.directoryEntriesInPath(list, file2, fileFilter);
            }
        }
    }

    public static String encodePath(String string) {
        return string.replaceAll(" ", "%20");
    }

    public static ArrayList<File> listFilesRecursively(File file, FileFilter fileFilter) {
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray2 = file.listFiles(fileFilter);
        arrayList.addAll(Arrays.asList(fileArray2));
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.isDirectory()) continue;
            arrayList.addAll(FileUtils.listFilesRecursively(file2, fileFilter));
        }
        return arrayList;
    }
}

